SET FOREIGN_KEY_CHECKS=0;
DROP TABLE IF EXISTS `backups`;
CREATE TABLE `backups` (
  `id_backup` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `file_name` varchar(255) DEFAULT NULL,
  `file_path` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_backup`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
DROP TABLE IF EXISTS `bank`;
CREATE TABLE `bank` (
  `id_bank` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `faktur` varchar(255) DEFAULT NULL,
  `jenis` varchar(255) DEFAULT NULL,
  `tanggal` date DEFAULT NULL,
  `waktu` time DEFAULT NULL,
  `pemasukan` int(11) DEFAULT NULL,
  `pengeluaran` int(11) DEFAULT NULL,
  `keterangan` varchar(255) DEFAULT NULL,
  `id_penjualan` int(11) unsigned DEFAULT NULL,
  `noref_nokartu` varchar(255) DEFAULT NULL,
  `id_toko` int(11) DEFAULT NULL,
  `id_login` int(11) DEFAULT NULL,
  `id_bank_akun` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_bank`),
  KEY `id_login` (`id_login`),
  KEY `id_toko` (`id_toko`),
  KEY `id_bank_akun` (`id_bank_akun`),
  KEY `id_penjualan` (`id_penjualan`),
  CONSTRAINT `bank_ibfk_1` FOREIGN KEY (`id_login`) REFERENCES `login` (`id_login`),
  CONSTRAINT `bank_ibfk_2` FOREIGN KEY (`id_toko`) REFERENCES `toko` (`id_toko`),
  CONSTRAINT `bank_ibfk_3` FOREIGN KEY (`id_bank_akun`) REFERENCES `bank_akun` (`id_bank_akun`),
  CONSTRAINT `bank_ibfk_4` FOREIGN KEY (`id_penjualan`) REFERENCES `penjualan` (`id_penjualan`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
DROP TABLE IF EXISTS `bank_akun`;
CREATE TABLE `bank_akun` (
  `id_bank_akun` int(11) NOT NULL AUTO_INCREMENT,
  `nama_bank` varchar(255) DEFAULT NULL,
  `bank_nama` varchar(255) DEFAULT NULL,
  `no_rekening` varchar(255) DEFAULT NULL,
  `utama` int(11) NOT NULL DEFAULT 0,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_bank_akun`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;
INSERT INTO `bank_akun` (`id_bank_akun`,`nama_bank`,`bank_nama`,`no_rekening`,`utama`,`created_at`,`updated_at`) VALUES ('1','BANK 1, Purwokerto','John Doe','123456789','0',NULL,'2025-10-05 06:51:44'), 
('2','Shopeepay','Shopeepay','08123456789','1','2025-10-05 06:48:45','2025-10-05 06:51:44');
DROP TABLE IF EXISTS `barang`;
CREATE TABLE `barang` (
  `id_barang` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `uuid_barang` char(36) NOT NULL DEFAULT '',
  `kode_barang` varchar(255) DEFAULT NULL,
  `barcode` varchar(255) DEFAULT NULL,
  `id_kategori` int(11) unsigned NOT NULL DEFAULT 0,
  `id_kontak` int(11) unsigned DEFAULT NULL,
  `sku` varchar(255) DEFAULT NULL,
  `nama_barang` varchar(255) NOT NULL DEFAULT '',
  `merk` varchar(255) NOT NULL,
  `harga_beli` int(11) NOT NULL DEFAULT 0,
  `diskon` int(11) NOT NULL DEFAULT 0,
  `diskon_persen` int(11) NOT NULL DEFAULT 0,
  `harga_jual` int(11) NOT NULL DEFAULT 0,
  `harga_pelanggan` int(11) NOT NULL DEFAULT 0,
  `harga_sales` int(11) NOT NULL DEFAULT 0,
  `range_harga` varchar(255) DEFAULT NULL,
  `satuan_barang` varchar(255) NOT NULL,
  `satuan_nilai` int(11) NOT NULL DEFAULT 0,
  `deskripsi` text DEFAULT NULL,
  `stok` int(11) NOT NULL DEFAULT 0,
  `stok_min` int(11) NOT NULL DEFAULT 0,
  `stok_gudang` int(11) NOT NULL DEFAULT 0,
  `expired` datetime DEFAULT NULL,
  `active` int(11) DEFAULT 0,
  `id_toko` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_barang`),
  KEY `id_kategori` (`id_kategori`),
  CONSTRAINT `barang_ibfk_1` FOREIGN KEY (`id_kategori`) REFERENCES `kategori` (`id_kategori`)
) ENGINE=InnoDB AUTO_INCREMENT=68 DEFAULT CHARSET=utf8;
INSERT INTO `barang` (`id_barang`,`uuid_barang`,`kode_barang`,`barcode`,`id_kategori`,`id_kontak`,`sku`,`nama_barang`,`merk`,`harga_beli`,`diskon`,`diskon_persen`,`harga_jual`,`harga_pelanggan`,`harga_sales`,`range_harga`,`satuan_barang`,`satuan_nilai`,`deskripsi`,`stok`,`stok_min`,`stok_gudang`,`expired`,`active`,`id_toko`,`created_at`,`updated_at`) VALUES ('1','c2FsbvWSQeBAP5WtfWsh4d','BRG-00001','8990000000010','5','2','BRG-001','8 PCS SABUN K NATURAL WHITE 85GRAM FREE 2 TEPAK -Soap','Sabun','20000','2000','6','32000','0','0',NULL,'pcs','8','Paket ini berisi 8 buah sabun dengan berat 85 gram setiapnya. ????
Dilengkapi dengan 2 tepak gratis. ????
Sabun K Natural White menawarkan pilihan wangi yang menarik. ????
Cocok untuk pengguna yang mencari sabun dengan berbagai varian wangi. ????
Pastikan untuk memilih varian yang sesuai dengan kebutuhan Anda. ????','498','1','0','2027-10-31 00:00:00','1','1','2025-10-05 20:47:50','2025-10-15 06:11:05'), 
('2','TfxszdPjJn2r93q2H28VAe','BRG-00002','8990000000027','5','2','BRG-002','Giv Bar Soap White Hijab Saffron & Niacinamide','Sabun','3000','0','0','4500','0','0',NULL,'pcs','1','GIV White Hijab sabun mandi (bodywash) dengan kandungan Saffron & Niacinamide, membuat kulit glowing seperti permata.
Keunggulan :
1. Mengandung Saffron & Niacinamide membantu mencerahkan kulit,
2. Sabun Mandi Halal & cocok untuk hijabers,
3. Membantu menjaga kelembapan kulit meski dibalik hijab,
4. Lembut busanya saat dipakai mandi.','196','10','0','2027-10-14 00:00:00','1','1','2025-10-05 20:56:54','2025-10-15 06:16:02'), 
('3','4Ca2y85NED3QXfmDQ6G6wm','BRG-00003','8990000000034','6','2','BRG-003','Bango Kecap Manis Refill Pouch Besar 950G','Bahan Makanan','11000','0','0','16000','0','0',NULL,'gram','1','Kecap Manis Bango / Soy Sauce Refill 950G terbuat dari 100% bahan alami yang berkualitas tinggi: kedelai hitam Mallika, gula, garam dan air.','95','1','0','2026-08-12 00:00:00','1','1','2025-10-05 21:04:24','2025-11-11 19:28:59'), 
('4','bBqNHqof5Cg7VExFvmSWtW','BRG-00004','8990000000011','6','2','BRG-004','DUA BELIBIS VALUE SAOS CABE POUCH','Bahan Makanan','17000','1500','6','24200','0','0',NULL,'kg','1','DUA BELIBIS VALUE SAOS CABE (1kg)✨ Rasakan Keistimewaan Saus Cabe Dua Belibis ✨
• Saus Cabe Dua Belibis terbuat dari bahan berkualitas dan premium. Perpaduan rasa cabai dan bawang dengan konsentrasi yang tinggi menjadikan saus sambal ini lebih istimewa.
• Kemasan Praktis: Kemasan Pouch dengan berat 1 kg, saus ini siap memenuhi kebutuhan Anda. Cocok untuk berbagai hidangan yang membutuhkan rasa cabai yang kaya. Rasakan perbedaannya dalam setiap penggunaan.','144','10','0','2026-02-02 00:00:00','1','1','2025-10-05 21:08:56','2025-11-11 19:28:59'), 
('5','4Nh8gohEP2XdMefqRV8ZT9','BRG-00005','8998989300261','4',NULL,'BRG 005','SURYA 12','SURYA 12','26000','0','0','27000','0','0',NULL,'bungkus','1','','5','0','0',NULL,'1','1','2025-10-13 11:03:08','2025-10-15 06:16:02'), 
('6','Cg7pXtTJXVW4nKwBDLvwKh','BRG-00006','123456789123','5',NULL,'BRG 006','SABUN COLEK','SABUN COLEK','1500','0','0','2000','0','0',NULL,'pcs','1','','9','0','0',NULL,'1','1','2025-10-13 11:05:30','2025-10-13 18:42:03'), 
('7','Q8QxkNSvRoGnhM3PXtTpbT','BRG-00007','12343212343','1',NULL,'BRG 888','BUKU','BUKU','1500','200','10','2000','0','0',NULL,'pcs','1','','9','0','0',NULL,'1','1','2025-10-13 12:58:47','2025-10-15 06:11:05'), 
('8','rb7HAWYfLogXgndMuMD2fF','BRG-00008','8997018320805','4',NULL,'BRG 006','GAJAH BARU KRETEK 16','GAJAH BARU KRETEK 16','10000','0','0','10500','0','0',NULL,'bungkus','1','','100','0','0',NULL,'1','1','2025-10-13 18:20:32','2025-10-13 18:20:32'), 
('9','RdzbMhwZsmG5xx6uBzZsjN','BRG-00009','8991918101045','4',NULL,'BRG 007','SCORPION 20','SCORPION 20','29000','0','0','30000','0','0',NULL,'bungkus','1','','99','0','0',NULL,'1','1','2025-10-13 18:22:15','2025-10-15 06:11:05'), 
('10','VankqocFrfb9w4ZJwxNsJ6','BRG-00010','8997018320829','4',NULL,'BRG 008','GAJAH BARU FILTER','GAJAH BARU FILTER','17000','0','0','18000','0','0',NULL,'bungkus','1','','98','0','0',NULL,'1','1','2025-10-13 18:26:48','2025-10-15 06:16:02'), 
('11','n7ns4ec5B9NBqeXsFzCXZE','BRG-00011','8999909096004','4',NULL,'BRG 009','SAMPOERNA MILD','SAMPOERNA MILD','35000','0','0','36000','0','0',NULL,'bungkus','1','','100','0','0',NULL,'1','1','2025-10-13 18:30:05','2025-10-13 18:30:05'), 
('12','t5swzuXVjKQXyHQ2Pa4bTL','BRG-00012','8999909012547','4',NULL,'BRG 010','SAMPOERNA PRIMA','SAMPOERNA PRIMA','15000','0','0','16000','0','0',NULL,'bungkus','1','','99','0','0',NULL,'1','1','2025-10-13 18:33:24','2025-10-15 06:11:05'), 
('13','MptAhVNCYKcRtEc42WBsC2','BRG-00013','8998989520126','4',NULL,'BRG 011','SRIWIDARI 12','SRIWIDARI 12','14500','0','0','15000','0','0',NULL,'bungkus','1','','100','0','0',NULL,'1','1','2025-10-13 18:36:04','2025-10-13 18:36:04'), 
('14','mK47AVvdQWFLQuJmYVfMZY','BRG-00014','8993587789999','4',NULL,'BRG 012','TUTON SPR','TUTON SPR','17000','0','0','18000','0','0',NULL,'bungkus','1','','100','0','0',NULL,'1','1','2025-10-13 18:37:41','2025-10-13 18:37:41'), 
('15','wJTdAk4KZZ3Znqo2wKz9rL','BRG-00015','8999909028999','4',NULL,'BRG 013','DJI SAM SOE 12','DJI SAM SOE 12','22000','0','0','23000','0','0',NULL,'bungkus','1','','100','0','0',NULL,'1','1','2025-10-13 18:39:36','2025-10-13 18:39:36'), 
('16','5MoL7Bd7ocD8fgFxgYe4be','BRG-00016','8998989110167','4',NULL,'BRG 014','SURYA 16','SURYA 16','35000','0','0','36000','0','0',NULL,'bungkus','1','','100','0','0',NULL,'1','1','2025-10-13 18:41:07','2025-10-13 18:41:07'), 
('17','HtJUTofw6utRfPqrPcseyS','BRG-00017','8999909010475','4',NULL,'BRG 015','DJI SAM SOE 16','DJI SAM SOE 16','27000','0','0','28000','0','0',NULL,'bungkus','1','','100','0','0',NULL,'1','1','2025-10-13 18:50:27','2025-10-13 18:50:55'), 
('18','oGmBrovE79RiBBmwRFQpMb','BRG-00018','8998989100120','4',NULL,'BRG 016','GUDANG GARAM FILTER 12','GUDANG GARAM FILTER 12','26000','0','0','27000','0','0',NULL,'bungkus','1','','100','0','0',NULL,'1','1','2025-10-13 18:52:49','2025-10-13 18:52:49'), 
('19','rffLgFT6NZeMKR9cLZj4sK','BRG-00019','8998989300155','4',NULL,'BRG 017','GUDANG GARAM SIGNATURE ','GUDANG GARAM SIGNATURE ','24000','0','0','25000','0','0',NULL,'bungkus','1','','99','0','0',NULL,'1','1','2025-10-13 18:54:12','2025-10-15 06:11:05'), 
('20','HPzBMrmucUgZbFbVX8MQnC','BRG-00020','8997243450087','4',NULL,'BRG 018','ALAMI UNGGUL JAYA','ALAMI UNGGUL JAYA','10000','0','0','11000','0','0',NULL,'bungkus','1','','100','0','0',NULL,'1','1','2025-10-13 18:55:35','2025-10-13 18:55:35'), 
('21','p5Ei9qd8mxW3QL3VLDRK7H','BRG-00021','8999909000773','4',NULL,'BRG 019','MARLBORO FILTER BLACK','MARLBORO FILTER BLACK','24000','0','0','25000','0','0',NULL,'bungkus','1','','100','0','0',NULL,'1','1','2025-10-13 18:57:01','2025-10-13 18:57:01'), 
('22','yZz4qNnmswtwGAmwED6WuU','BRG-00022','8999909085114','4',NULL,'BRG 020','SAMPOERNA KRETEK 12','SAMPOERNA KRETEK 12','15000','0','0','16000','0','0',NULL,'bungkus','1','','100','0','0',NULL,'1','1','2025-10-13 18:58:49','2025-10-13 18:58:49'), 
('23','G24T5NUWbXjvjxraE6aQoU','BRG-00023','8991902102003','4',NULL,'BRG 021','SAMPOERNA KRETEK 12','SAMPOERNA KRETEK 12','17000','0','0','18000','0','0',NULL,'bungkus','1','','100','0','0',NULL,'1','1','2025-10-13 19:00:40','2025-10-13 19:00:40'), 
('24','pgjGsfpi42cE5LRCvhfMGC','BRG-00024','8990111211001','4',NULL,'BRG 022','ALAMI COKLAT 101','ALAMI COKLAT 101','10000','0','0','11000','0','0',NULL,'bungkus','1','','100','0','0',NULL,'1','1','2025-10-13 19:02:02','2025-10-13 19:02:02'), 
('25','2fmMMDPVStGFgWk5afXH7R','BRG-00025','8999909001909','4',NULL,'BRG 023','MAGNUM FILTER 12','MAGNUM FILTER 12','27000','200','1','28000','0','0',NULL,'bungkus','1','','100','0','0',NULL,'1','1','2025-10-13 19:03:41','2025-10-13 19:03:41'), 
('26','ycmu6vYhpFVyvMu2ZjsdoH','BRG-00026','8994796281601','4',NULL,'BRG 026','AROMA BOLD 16','AROMA BOLD 16','22000','0','0','23000','0','0',NULL,'bungkus','1','','100','0','0',NULL,'1','1','2025-10-13 19:07:44','2025-10-13 19:07:44'), 
('27','QQmYwyZ8awvm7X5dTAEMcT','BRG-00027','8997223733971','4',NULL,' BRG 027','TWIST ','TWIST ','25000','200','1','26000','0','0',NULL,'bungkus','1','','100','0','0',NULL,'1','1','2025-10-13 19:09:23','2025-10-13 19:09:23'), 
('28','nSqDo3UhviL9Jf4kPnyEaL','BRG-00028','8991906101811','4',NULL,'BRG 028','DJARUM 76','DJARUM 76','15000','200','1','16000','0','0',NULL,'bungkus','1','','100','0','0',NULL,'1','1','2025-10-13 19:12:42','2025-10-13 19:12:42'), 
('29','SfA7sVJ7jyDcNeuRYc9p98','BRG-00029','8991906101019','4',NULL,'BRG 029','DJARUM SUPER NEW','DJARUM SUPER NEW','25000','200','1','26000','0','0',NULL,'bungkus','1','','100','0','0',NULL,'1','1','2025-10-13 19:14:29','2025-10-13 19:14:29'), 
('30','m2WzcedEWapx5qJk9AqiTF','BRG-00030','8991906101712','4',NULL,'BRG 030','DJARUM COKLAT EXTRA','DJARUM COKLAT EXTRA','16000','200','1','17000','0','0',NULL,'bungkus','1','','100','0','0',NULL,'1','1','2025-10-13 19:15:53','2025-10-13 19:15:53'), 
('31','qdeeqef2kH3NdL6ZGJMzpG','BRG-00031','8991906106205','4',NULL,'BRG 031','DJARUM COKLAT ELITE 12','DJARUM COKLAT ELITE 12','17000','200','1','18000','0','0',NULL,'bungkus','1','','100','0','0',NULL,'1','1','2025-10-13 19:17:08','2025-10-13 19:17:08'), 
('32','z65JL2zYeQu9i7csLRo3Dm','BRG-00032','8991906106250','4',NULL,'BRG 032','DJARUM APEL ','DJARUM APEL ','15000','0','0','16000','0','0',NULL,'bungkus','1','','100','0','0',NULL,'1','1','2025-10-13 19:18:46','2025-10-13 19:18:46'), 
('33','d4xHkVGT5nX5cPoE2hZor9','BRG-00033','8999168211750','4',NULL,'BRG 033','JUARA BERY','JUARA BERY','15000','0','0','16000','0','0',NULL,'bungkus','1','','100','0','0',NULL,'1','1','2025-10-13 19:19:59','2025-10-13 19:19:59'), 
('34','yRzAGWXebNKqSMaQD4H3VR','BRG-00034','8994214995868','4',NULL,'BRG 034','DIPLOMAT MILD  BERY ','DIPLOMAT MILD  BERY','25000','0','0','26000','0','0',NULL,'bungkus','1','','100','0','0',NULL,'1','1','2025-10-13 19:21:20','2025-10-13 19:21:20'), 
('35','8ACFecchcVZUCAtaUjtW7F','BRG-00035','8997207198871','4',NULL,'BRG 035','COUNTRY 20','COUNTRY 20','28000','0','0','2900','0','0',NULL,'bungkus','1','','100','0','0',NULL,'1','1','2025-10-13 19:22:41','2025-10-13 19:22:41'), 
('36','We8d2SBZjE5jDhkkmaXKsZ','BRG-00036','8998989501125','4',NULL,'BRG 036',' GUDANG GARAM MMERAH 12',' GUDANG GARAM MMERAH 12','15000','0','0','16000','0','0',NULL,'bungkus','1','','100','0','0',NULL,'1','1','2025-10-13 19:24:15','2025-10-13 19:24:15'), 
('37','K7kWFtG8GxkedVKMvy6psf','BRG-00037','8991906105758','4',NULL,' BRG 037','LA BOLD 20','LA BOLD 20','41000','0','0','42000','0','0',NULL,'bungkus','1','','100','0','0',NULL,'1','1','2025-10-13 19:25:44','2025-10-13 19:25:44'), 
('38','QFwAC4yGBnDNNXLcmMJe6X','BRG-00038','8994214995547','4',NULL,'BRG 038','EVO DIPLOMAT','EVO DIPLOMAT','25000','0','0','26000','0','0',NULL,'bungkus','1','','100','0','0',NULL,'1','1','2025-10-13 19:27:01','2025-10-13 19:27:01'), 
('39','s57KwsZszwFZGZQCSCVNPb','BRG-00039','8997207190134','4',NULL,'BRG 039','ARES BOLD SERIES 12','ARES BOLD SERIES 12','16000','0','0','17000','0','0',NULL,'bungkus','1','','100','0','0',NULL,'1','1','2025-10-13 19:28:39','2025-10-13 19:28:39'), 
('40','wSVUdqXuEAXW2og664kxmh','BRG-00040','8999909002821','4',NULL,'BRG 040','MARLBORO BLACK 16','MARLBORO BLACK 16','33000','0','0','34000','0','0',NULL,'bungkus','1','','100','0','0',NULL,'1','1','2025-10-13 19:30:30','2025-10-13 19:30:30'), 
('41','EDKvkz4bZzM8kSjSKFwsWS','BRG-00041','8994214110124','4',NULL,'BRG 041','DIPLOMAT HITAM','DIPLOMAT HITAM','24000','0','0','25000','0','0',NULL,'bungkus','1','','100','0','0',NULL,'1','1','2025-10-13 19:31:44','2025-10-13 19:31:44'), 
('42','i36apcvgdPiA3z5PGbByej','BRG-00042','76164217','4',NULL,' BRG 042','MARLBORO MERAH 20','MARLBORO MERAH 20','44000','0','0','45000','0','0',NULL,'bungkus','1','','1000','0','0',NULL,'1','1','2025-10-13 19:33:18','2025-10-13 19:33:18'), 
('43','cnXquomA23TLizYQDJnr9D','BRG-00043','8991907102510','4',NULL,'BRG 043','DIO JAMBU',' DIO JAMBU ','90000','0','0','10000','0','0',NULL,'bungkus','1','','100','0','0',NULL,'0','1','2025-10-13 19:34:40','2025-10-13 19:34:40'), 
('44','t2JxhSizBpScnX2ecfsH56','BRG-00044','8999909000544','4',NULL,' BRG 044','MARLBORO MERAH 20','MARLBORO MERAH 20','39000','0','0','40000','0','0',NULL,'bungkus','1','','100','0','0',NULL,'1','1','2025-10-13 19:36:46','2025-10-13 19:36:46'), 
('45','eLhKJWxpXaufWU8prmazSL','BRG-00045','8998866107068','5',NULL,'BRG 045','MAMA LEMON 230 ML','MAMA LEMON 230 ML','3500','0','0','4000','0','0',NULL,'pcs','1','','100','0','0',NULL,'1','1','2025-10-13 19:40:05','2025-10-13 19:40:05'), 
('46','PuTC6pgWtE2T6EvT9hEjYh','BRG-00046','8999999050009','5',NULL,' BRG 046','SUNLIHGT 90G','SUNLIHGT 90G','1500','0','0','1800','0','0',NULL,'pcs','1','','100','0','0',NULL,'1','1','2025-10-13 19:41:43','2025-10-13 19:41:43'), 
('47','KRwVt7Zpf7h8Nw5PpYkhHa','BRG-00047','8999908908407','5',NULL,'BRG 047','SOS  ANTIBACTERIAL BODY  WASH 400M','SOS  ANTIBACTERIAL BODY  WASH 400M','18000','0','0','19000','0','0',NULL,'pcs','1','','100','0','0',NULL,'1','1','2025-10-13 19:44:09','2025-10-13 19:44:09'), 
('48','QHv6JCmtb5xUaZpRSmc7XX','BRG-00048','8999999603830','5',NULL,'BRG 050','SUNLIHG 585ML','SUNLIHG 585ML','11000','0','0','11500','0','0',NULL,'pcs','1','BIO CARE NATURE','100','0','0',NULL,'1','1','2025-10-13 19:46:14','2025-10-13 19:52:10'), 
('49','afW9wxxrXJirHHHD7zBr2S','BRG-00049','089686010947','6',NULL,'BRG 048','INDOMIE MIE GORENG','INDOMIE MIE GORENG','3100','0','0','3300','0','0',NULL,'pcs','1','','100','0','0',NULL,'1','1','2025-10-13 19:48:46','2025-10-13 19:48:46'), 
('50','fmaKue8LWoKiAYaKApTJe3','BRG-00050','089686014280','6',NULL,'BRG 049','SUPERMIE AYAM BAWANG ','SUPERMIE AYAM BAWANG ','2800','0','0','2900','0','0',NULL,'pcs','1','','100','0','0',NULL,'1','1','2025-10-13 19:50:49','2025-10-13 19:50:49'), 
('51','vDidT7yaTexPEdXJYoMmLf','BRG-00051','089686043433','3',NULL,' BRG 051','INDOMIE HIPE ABIS','INDOMIE HIPE ABIS','3100','0','0','3300','0','0',NULL,'pcs','1','','100','0','0',NULL,'1','1','2025-10-13 19:53:46','2025-10-13 19:53:46'), 
('52','JnyF8PoXVNK22YyGr97LHU','BRG-00052','8998866200325','6',NULL,' BRG 052','SEDAP SOTO','SEDAP SOTO','2800','0','0','2900','0','0',NULL,'pcs','1','','100','0','0',NULL,'1','1','2025-10-13 20:08:32','2025-10-13 20:08:32'), 
('53','LL63DgqasE9tzWAUziQVrN','BRG-00053','(90)MD243735006900168','6',NULL,'BRG 053','SEDAP GORENG','SEDAP GORENG','3200','0','0','3300','0','0',NULL,'pcs','1','','100','0','0',NULL,'1','1','2025-10-13 20:13:26','2025-10-13 20:13:47'), 
('54','nDiXHnvE4Z3XvDZvqydBxk','BRG-00054','(90)MD240935004500027','6',NULL,'BRG054','INDOMIE SOTO','INDOMIE SOTO','3100','0','0','3200','0','0',NULL,'pcs','1','','100','0','0',NULL,'1','1','2025-10-13 20:18:00','2025-10-13 20:33:54'), 
('55','egLnd9reC3Xfnuvy9pzqxL','BRG-00055','8998866202343','6',NULL,' BRG 055','SEDAP GORENG KOREA','SEDAP GORENG KOREA','3200','0','0','3300','0','0',NULL,'pcs','1','','100','0','0',NULL,'1','1','2025-10-13 20:22:54','2025-10-13 20:32:19'), 
('56','cfdxpJLby26LEqAPazTzp6','BRG-00056','089686060126','6',NULL,'BRG 056','POPMIE SOTO','POPMIE SOTO','4800','0','0','5000','0','0',NULL,'pcs','1','','100','0','0',NULL,'1','1','2025-10-13 20:26:18','2025-10-13 20:32:12'), 
('57','iWMS2KeqDq3mZPd4CNEWF2','BRG-00057','089686061024','6',NULL,'BRG 057','POPMIE AYAM BAWANG MINI','POPMIE AYAM BAWANG MINI','3400','0','0','3500','0','0',NULL,'pcs','1','','100','0','0',NULL,'1','1','2025-10-13 20:30:51','2025-10-13 20:33:19'), 
('58','7dqxyRBwD5ahFKA4kJywp9','BRG-00058','723784412746','3',NULL,'BRG 058','sensi  l isi 30 pcs','sensi  l isi 30 pcs','49000','0','0','50000','0','0',NULL,'bungkus','1','sensi  l isi 30 pcs','10','0','0',NULL,'1','1','2025-10-13 20:43:32','2025-10-13 20:43:32'), 
('59','dhrq5zcPDKAHLZ8MXDaRkg','BRG-00059','8990052002836','3',NULL,NULL,'makuku dry care m isi  30+6','makuku drycare misi30+6','53000','0','0','54000','0','0',NULL,'bungkus','1','','10','0','0',NULL,'1','1','2025-10-13 20:53:26','2025-10-13 20:53:26'), 
('60','RbjSqjALmYZ8GrJfR8vRaH','BRG-00060','https://lp.makuku.co.id/id/makuku/','3',NULL,'brg 060','makuku l isi 28+6 pcs','makuku l isi 28+6 pcs','53000','0','0','54000','0','0',NULL,'bungkus','1','','10','0','0',NULL,'1','1','2025-10-13 21:05:31','2025-10-13 21:05:31'), 
('61','X4nXGiaYZNLKuDyiT9pSmS','BRG-00061','8997004891913','3',NULL,' brg 061','poki poki l isi 26+2 pcs','poki poki l isi 26 +2 pcs','48000','0','0','49000','0','0',NULL,'bungkus','1','','10','0','0',NULL,'1','1','2025-10-13 21:13:25','2025-10-13 21:13:25'), 
('62','hcvc7E6i2wqdnj7ZCsmt5N','BRG-00062','8993189272134','3',NULL,'brg 062','mami poko m isi 32 pcs','mami poko m isi 32 pcs','51000','0','0','52000','0','0',NULL,'bungkus','1','','10','0','0',NULL,'1','1','2025-10-13 21:16:49','2025-10-13 21:16:49'), 
('63','RkXrRgNWAGFUhJsj5nqZ3E','BRG-00063','8992959953181','3',NULL,'brg 062','swity l isi 28 pcs','swity l isi 28 pcs','51000','0','0','52000','0','0',NULL,'bungkus','1','','10','0','0',NULL,'1','1','2025-10-13 21:20:34','2025-10-13 21:20:34'), 
('64','wRJmBxtP79TT4GUJNFLPoN','BRG-00064','8998866500555','3',NULL,'brg 063','baby happy l 28 pcs','baby happy l 28 pcs','47000','0','0','48000','0','0',NULL,'bungkus','1','','10','0','0',NULL,'1','1','2025-10-13 21:25:38','2025-10-13 21:25:38'), 
('65','apnFCi6Kzii3FJDcW67GXJ','BRG-00065','8998866501217','3',NULL,'brg 064','baby happy s 38 pcs','baby happy s 38  pcs','47000','0','0','48000','0','0',NULL,'bungkus','1','','10','0','0',NULL,'1','1','2025-10-13 21:30:21','2025-10-13 21:30:21'), 
('66','Muq5fCAAhU6JqhqFmUSJTb','BRG-00066','8998866500500','3',NULL,'brg 065','baby happy m 32 pcs','baby happy m 32 pcs ','47000','0','0','48000','0','0',NULL,'bungkus','1','','10','0','0',NULL,'1','1','2025-10-13 21:34:51','2025-10-13 21:34:51'), 
('67','94K9jVUKq8JgmT6ceZBvzS','BRG-00067','8997226052161','3',NULL,'BRG O66','LAMPU HEMAT 5 WAT','LAMPU HEMAT 5 WAT','7500','0','0','8000','0','0',NULL,'pcs','1','','100','0','0',NULL,'1','1','2025-10-14 05:34:52','2025-10-14 05:34:52');
DROP TABLE IF EXISTS `biaya`;
CREATE TABLE `biaya` (
  `id_biaya` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `faktur` varchar(255) DEFAULT NULL,
  `tanggal` date DEFAULT NULL,
  `waktu` time DEFAULT NULL,
  `jenis` varchar(255) DEFAULT NULL,
  `nominal` int(11) NOT NULL DEFAULT 0,
  `keterangan` varchar(255) DEFAULT NULL,
  `id_toko` int(11) DEFAULT NULL,
  `id_login` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_biaya`),
  KEY `id_toko` (`id_toko`),
  KEY `id_login` (`id_login`),
  CONSTRAINT `biaya_ibfk_1` FOREIGN KEY (`id_toko`) REFERENCES `toko` (`id_toko`),
  CONSTRAINT `biaya_ibfk_2` FOREIGN KEY (`id_login`) REFERENCES `login` (`id_login`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `cashflow`;
CREATE TABLE `cashflow` (
  `id_cashflow` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `faktur` varchar(255) DEFAULT NULL,
  `jenis` varchar(255) DEFAULT NULL,
  `kategori` varchar(255) DEFAULT NULL,
  `tanggal` date DEFAULT NULL,
  `waktu` time DEFAULT NULL,
  `pemasukan` int(11) NOT NULL DEFAULT 0,
  `pengeluaran` int(11) NOT NULL DEFAULT 0,
  `keterangan` varchar(255) DEFAULT NULL,
  `id_penjualan` int(11) unsigned DEFAULT NULL,
  `id_pembelian` int(11) unsigned DEFAULT NULL,
  `id_biaya` int(11) unsigned DEFAULT NULL,
  `id_toko` int(11) DEFAULT NULL,
  `id_login` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_cashflow`),
  KEY `id_penjualan` (`id_penjualan`),
  KEY `id_pembelian` (`id_pembelian`),
  KEY `id_biaya` (`id_biaya`),
  KEY `id_toko` (`id_toko`),
  KEY `id_login` (`id_login`),
  CONSTRAINT `cashflow_ibfk_1` FOREIGN KEY (`id_penjualan`) REFERENCES `penjualan` (`id_penjualan`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `cashflow_ibfk_2` FOREIGN KEY (`id_pembelian`) REFERENCES `pembelian` (`id_pembelian`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `cashflow_ibfk_3` FOREIGN KEY (`id_biaya`) REFERENCES `biaya` (`id_biaya`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `cashflow_ibfk_4` FOREIGN KEY (`id_toko`) REFERENCES `toko` (`id_toko`),
  CONSTRAINT `cashflow_ibfk_5` FOREIGN KEY (`id_login`) REFERENCES `login` (`id_login`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;
INSERT INTO `cashflow` (`id_cashflow`,`faktur`,`jenis`,`kategori`,`tanggal`,`waktu`,`pemasukan`,`pengeluaran`,`keterangan`,`id_penjualan`,`id_pembelian`,`id_biaya`,`id_toko`,`id_login`,`created_at`,`updated_at`) VALUES ('1','PJ/061025-021220','Pemasukan','Penjualan','2025-10-06','02:12:20','20700','0','Penjualan: PJ/061025-021220','1',NULL,NULL,'1','1','2025-10-06 02:12:20',NULL), 
('2','PJ/131025-110847','Pemasukan','Penjualan','2025-10-13','11:08:47','56200','0','Penjualan: PJ/131025-110847','2',NULL,NULL,'1','1','2025-10-13 11:08:47',NULL), 
('3','PJ/131025-125936','Pemasukan','Penjualan','2025-10-13','12:59:36','79700','0','Penjualan: PJ/131025-125936','3',NULL,NULL,'1','1','2025-10-13 12:59:36',NULL), 
('4','PJ/131025-130759','Pemasukan','Penjualan','2025-10-13','13:07:59','51300','0','Penjualan: PJ/131025-130759','4',NULL,NULL,'1','1','2025-10-13 13:07:59',NULL), 
('5','PJ/131025-184203','Pemasukan','Penjualan','2025-10-13','18:42:03','30800','0','Penjualan: PJ/131025-184203','5',NULL,NULL,'1','1','2025-10-13 18:42:03',NULL), 
('6','PJ/151025-061105','Pemasukan','Penjualan','2025-10-15','06:11:05','217994','0','Penjualan: PJ/151025-061105','6',NULL,NULL,'1','1','2025-10-15 06:11:05',NULL), 
('7','PJ/151025-061602','Pemasukan','Penjualan','2025-10-15','06:17:44','5000','0','Pembayaran Piutang Penjualan: PJ/151025-061602',NULL,NULL,NULL,'1','1','2025-10-15 06:17:44',NULL), 
('8','PJ/151025-061602','Pemasukan','Penjualan','2025-10-15','06:18:07','79','0','Pembayaran Piutang Penjualan: PJ/151025-061602',NULL,NULL,NULL,'1','1','2025-10-15 06:18:07',NULL), 
('9','PJ/151025-061602','Pemasukan','Penjualan','2025-10-15','06:18:35','79000','0','Pembayaran Piutang Penjualan: PJ/151025-061602',NULL,NULL,NULL,'1','1','2025-10-15 06:18:35',NULL), 
('10','PJ/151025-061602','Pemasukan','Penjualan','2025-10-15','06:19:06','4121','0','Pembayaran Piutang Penjualan: PJ/151025-061602',NULL,NULL,NULL,'1','1','2025-10-15 06:19:06',NULL), 
('11','PJ/111125-192859','Pemasukan','Penjualan','2025-11-11','19:28:59','54700','0','Penjualan: PJ/111125-192859','8',NULL,NULL,'1','1','2025-11-11 19:28:59',NULL);
DROP TABLE IF EXISTS `groups`;
CREATE TABLE `groups` (
  `id_group` int(11) NOT NULL AUTO_INCREMENT,
  `nama_group` varchar(255) NOT NULL,
  `permission` text NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_group`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
INSERT INTO `groups` (`id_group`,`nama_group`,`permission`,`created_at`,`updated_at`) VALUES ('1','Administrator','a:84:{i:0;s:13:\"viewDashboard\";i:1;s:13:\"menuDashboard\";i:2;s:10:\"menuBarang\";i:3;s:10:\"viewBarang\";i:4;s:12:\"createBarang\";i:5;s:12:\"updateBarang\";i:6;s:12:\"deleteBarang\";i:7;s:9:\"viewExcel\";i:8;s:11:\"createExcel\";i:9;s:13:\"viewStokInOut\";i:10;s:15:\"createStokInOut\";i:11;s:15:\"updateStokInOut\";i:12;s:15:\"deleteStokInOut\";i:13;s:14:\"viewStokOpname\";i:14;s:16:\"createStokOpname\";i:15;s:16:\"updateStokOpname\";i:16;s:16:\"deleteStokOpname\";i:17;s:13:\"menuTransaksi\";i:18;s:13:\"viewPenjualan\";i:19;s:15:\"createPenjualan\";i:20;s:15:\"updatePenjualan\";i:21;s:15:\"deletePenjualan\";i:22;s:13:\"viewPembelian\";i:23;s:15:\"createPembelian\";i:24;s:15:\"updatePembelian\";i:25;s:15:\"deletePembelian\";i:26;s:10:\"viewHutang\";i:27;s:12:\"createHutang\";i:28;s:12:\"updateHutang\";i:29;s:12:\"deleteHutang\";i:30;s:11:\"viewPiutang\";i:31;s:13:\"createPiutang\";i:32;s:13:\"updatePiutang\";i:33;s:13:\"deletePiutang\";i:34;s:9:\"viewBiaya\";i:35;s:11:\"createBiaya\";i:36;s:11:\"updateBiaya\";i:37;s:11:\"deleteBiaya\";i:38;s:12:\"menuKeuangan\";i:39;s:12:\"viewCashflow\";i:40;s:14:\"createCashflow\";i:41;s:14:\"updateCashflow\";i:42;s:14:\"deleteCashflow\";i:43;s:8:\"viewBank\";i:44;s:10:\"createBank\";i:45;s:10:\"updateBank\";i:46;s:10:\"deleteBank\";i:47;s:9:\"viewPajak\";i:48;s:11:\"createPajak\";i:49;s:11:\"updatePajak\";i:50;s:11:\"deletePajak\";i:51;s:10:\"menuKontak\";i:52;s:10:\"viewKontak\";i:53;s:12:\"createKontak\";i:54;s:12:\"updateKontak\";i:55;s:12:\"deleteKontak\";i:56;s:8:\"menuUser\";i:57;s:8:\"viewUser\";i:58;s:10:\"createUser\";i:59;s:10:\"updateUser\";i:60;s:10:\"deleteUser\";i:61;s:9:\"viewGroup\";i:62;s:11:\"createGroup\";i:63;s:11:\"updateGroup\";i:64;s:11:\"deleteGroup\";i:65;s:11:\"menuSetting\";i:66;s:11:\"viewSetting\";i:67;s:13:\"updateSetting\";i:68;s:10:\"viewConfig\";i:69;s:12:\"updateConfig\";i:70;s:12:\"viewBankAkun\";i:71;s:14:\"createBankAkun\";i:72;s:14:\"updateBankAkun\";i:73;s:14:\"deleteBankAkun\";i:74;s:10:\"viewBackup\";i:75;s:12:\"createBackup\";i:76;s:12:\"deleteBackup\";i:77;s:11:\"viewLaporan\";i:78;s:11:\"menuLaporan\";i:79;s:19:\"viewLaporanLabaRugi\";i:80;s:13:\"viewStatistik\";i:81;s:13:\"menuStatistik\";i:82;s:11:\"updateShift\";i:83;s:11:\"deleteShift\";}',NULL,'2025-10-05 10:53:03'), 
('2','Manager','a:84:{i:0;s:13:\"viewDashboard\";i:1;s:13:\"menuDashboard\";i:2;s:10:\"menuBarang\";i:3;s:10:\"viewBarang\";i:4;s:12:\"createBarang\";i:5;s:12:\"updateBarang\";i:6;s:12:\"deleteBarang\";i:7;s:9:\"viewExcel\";i:8;s:11:\"createExcel\";i:9;s:13:\"viewStokInOut\";i:10;s:15:\"createStokInOut\";i:11;s:15:\"updateStokInOut\";i:12;s:15:\"deleteStokInOut\";i:13;s:14:\"viewStokOpname\";i:14;s:16:\"createStokOpname\";i:15;s:16:\"updateStokOpname\";i:16;s:16:\"deleteStokOpname\";i:17;s:13:\"menuTransaksi\";i:18;s:13:\"viewPenjualan\";i:19;s:15:\"createPenjualan\";i:20;s:15:\"updatePenjualan\";i:21;s:15:\"deletePenjualan\";i:22;s:13:\"viewPembelian\";i:23;s:15:\"createPembelian\";i:24;s:15:\"updatePembelian\";i:25;s:15:\"deletePembelian\";i:26;s:10:\"viewHutang\";i:27;s:12:\"createHutang\";i:28;s:12:\"updateHutang\";i:29;s:12:\"deleteHutang\";i:30;s:11:\"viewPiutang\";i:31;s:13:\"createPiutang\";i:32;s:13:\"updatePiutang\";i:33;s:13:\"deletePiutang\";i:34;s:9:\"viewBiaya\";i:35;s:11:\"createBiaya\";i:36;s:11:\"updateBiaya\";i:37;s:11:\"deleteBiaya\";i:38;s:12:\"menuKeuangan\";i:39;s:12:\"viewCashflow\";i:40;s:14:\"createCashflow\";i:41;s:14:\"updateCashflow\";i:42;s:14:\"deleteCashflow\";i:43;s:8:\"viewBank\";i:44;s:10:\"createBank\";i:45;s:10:\"updateBank\";i:46;s:10:\"deleteBank\";i:47;s:9:\"viewPajak\";i:48;s:11:\"createPajak\";i:49;s:11:\"updatePajak\";i:50;s:11:\"deletePajak\";i:51;s:10:\"menuKontak\";i:52;s:10:\"viewKontak\";i:53;s:12:\"createKontak\";i:54;s:12:\"updateKontak\";i:55;s:12:\"deleteKontak\";i:56;s:8:\"menuUser\";i:57;s:8:\"viewUser\";i:58;s:10:\"createUser\";i:59;s:10:\"updateUser\";i:60;s:10:\"deleteUser\";i:61;s:9:\"viewGroup\";i:62;s:11:\"createGroup\";i:63;s:11:\"updateGroup\";i:64;s:11:\"deleteGroup\";i:65;s:11:\"menuSetting\";i:66;s:11:\"viewSetting\";i:67;s:13:\"updateSetting\";i:68;s:10:\"viewConfig\";i:69;s:12:\"updateConfig\";i:70;s:12:\"viewBankAkun\";i:71;s:14:\"createBankAkun\";i:72;s:14:\"updateBankAkun\";i:73;s:14:\"deleteBankAkun\";i:74;s:10:\"viewBackup\";i:75;s:12:\"createBackup\";i:76;s:12:\"deleteBackup\";i:77;s:11:\"viewLaporan\";i:78;s:11:\"menuLaporan\";i:79;s:19:\"viewLaporanLabaRugi\";i:80;s:13:\"viewStatistik\";i:81;s:13:\"menuStatistik\";i:82;s:11:\"updateShift\";i:83;s:11:\"deleteShift\";}',NULL,'2025-10-05 10:56:57'), 
('3','Kasir','a:29:{i:0;s:13:\"viewDashboard\";i:1;s:13:\"menuDashboard\";i:2;s:13:\"menuTransaksi\";i:3;s:13:\"viewPenjualan\";i:4;s:15:\"createPenjualan\";i:5;s:15:\"updatePenjualan\";i:6;s:11:\"viewPiutang\";i:7;s:13:\"createPiutang\";i:8;s:13:\"updatePiutang\";i:9;s:9:\"viewBiaya\";i:10;s:11:\"createBiaya\";i:11;s:11:\"updateBiaya\";i:12;s:12:\"menuKeuangan\";i:13;s:12:\"viewCashflow\";i:14;s:14:\"createCashflow\";i:15;s:10:\"createBank\";i:16;s:9:\"viewPajak\";i:17;s:11:\"createPajak\";i:18;s:10:\"menuKontak\";i:19;s:10:\"viewKontak\";i:20;s:12:\"createKontak\";i:21;s:12:\"updateKontak\";i:22;s:10:\"viewConfig\";i:23;s:12:\"viewBankAkun\";i:24;s:11:\"viewLaporan\";i:25;s:11:\"menuLaporan\";i:26;s:13:\"viewStatistik\";i:27;s:13:\"menuStatistik\";i:28;s:11:\"updateShift\";}',NULL,'2025-10-05 20:22:32'), 
('4','Sales','a:8:{i:0;s:13:\"viewDashboard\";i:1;s:13:\"menuDashboard\";i:2;s:10:\"menuKontak\";i:3;s:10:\"viewKontak\";i:4;s:12:\"createKontak\";i:5;s:12:\"updateKontak\";i:6;s:12:\"deleteKontak\";i:7;s:11:\"updateShift\";}',NULL,'2025-10-05 20:22:40'), 
('5','Gudang','a:15:{i:0;s:13:\"viewDashboard\";i:1;s:13:\"menuDashboard\";i:2;s:10:\"menuBarang\";i:3;s:10:\"viewBarang\";i:4;s:12:\"createBarang\";i:5;s:12:\"updateBarang\";i:6;s:9:\"viewExcel\";i:7;s:11:\"createExcel\";i:8;s:13:\"viewStokInOut\";i:9;s:15:\"createStokInOut\";i:10;s:15:\"updateStokInOut\";i:11;s:14:\"viewStokOpname\";i:12;s:16:\"createStokOpname\";i:13;s:16:\"updateStokOpname\";i:14;s:11:\"updateShift\";}',NULL,'2025-10-05 20:22:49');
DROP TABLE IF EXISTS `hutang`;
CREATE TABLE `hutang` (
  `id_hutang` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `id_pembelian` int(11) unsigned NOT NULL,
  `tanggal` date DEFAULT NULL,
  `jatuh_tempo` date DEFAULT NULL,
  `jumlah_hutang` int(11) DEFAULT NULL,
  `jumlah_bayar` int(11) DEFAULT NULL,
  `sisa_hutang` int(11) DEFAULT NULL,
  `status_hutang` int(11) NOT NULL DEFAULT 0,
  `id_login` int(11) NOT NULL DEFAULT 0,
  `id_toko` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_hutang`),
  KEY `id_pembelian` (`id_pembelian`),
  KEY `id_login` (`id_login`),
  KEY `id_toko` (`id_toko`),
  CONSTRAINT `hutang_ibfk_1` FOREIGN KEY (`id_pembelian`) REFERENCES `pembelian` (`id_pembelian`),
  CONSTRAINT `hutang_ibfk_2` FOREIGN KEY (`id_login`) REFERENCES `login` (`id_login`),
  CONSTRAINT `hutang_ibfk_3` FOREIGN KEY (`id_toko`) REFERENCES `toko` (`id_toko`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
DROP TABLE IF EXISTS `hutang_bayar`;
CREATE TABLE `hutang_bayar` (
  `id_hutang_bayar` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `id_hutang` int(11) unsigned NOT NULL,
  `nominal` int(11) DEFAULT NULL,
  `id_cashflow` int(11) unsigned NOT NULL DEFAULT 0,
  `id_login` int(11) NOT NULL DEFAULT 0,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_hutang_bayar`),
  KEY `id_hutang` (`id_hutang`),
  CONSTRAINT `hutang_bayar_ibfk_1` FOREIGN KEY (`id_hutang`) REFERENCES `hutang` (`id_hutang`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
DROP TABLE IF EXISTS `kategori`;
CREATE TABLE `kategori` (
  `id_kategori` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `nama_kategori` varchar(255) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_kategori`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
INSERT INTO `kategori` (`id_kategori`,`nama_kategori`,`created_at`,`updated_at`) VALUES ('1','Kopi',NULL,NULL), 
('2','Beras','2025-10-05 15:52:25','2025-10-05 15:52:25'), 
('3','Sembako','2025-10-05 15:54:04','2025-10-05 15:54:04'), 
('4','Rokok','2025-10-05 20:37:40','2025-10-05 20:37:40'), 
('5','Sabun','2025-10-05 20:41:44','2025-10-05 20:41:52'), 
('6','Bahan Makanan','2025-10-05 21:02:18','2025-10-05 21:02:18');
DROP TABLE IF EXISTS `keranjang`;
CREATE TABLE `keranjang` (
  `id_keranjang` varchar(20) NOT NULL DEFAULT '',
  `id_barang` int(11) unsigned NOT NULL DEFAULT 0,
  `id_kontak` int(11) unsigned NOT NULL DEFAULT 0,
  `harga_beli` int(11) NOT NULL DEFAULT 0,
  `harga_jual` int(11) NOT NULL DEFAULT 0,
  `diskon` int(11) NOT NULL DEFAULT 0,
  `diskon_persen` int(11) NOT NULL DEFAULT 0,
  `stok` int(11) DEFAULT NULL,
  `qty` int(11) NOT NULL DEFAULT 0,
  `satuan` varchar(255) DEFAULT NULL,
  `hpp` int(11) NOT NULL DEFAULT 0,
  `jumlah` int(11) NOT NULL DEFAULT 0,
  `ppn` int(11) NOT NULL DEFAULT 0,
  `total_laba` int(11) NOT NULL DEFAULT 0,
  `id_login` int(11) NOT NULL DEFAULT 0,
  `id_toko` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_keranjang`),
  KEY `id_kontak` (`id_kontak`),
  KEY `id_barang` (`id_barang`),
  CONSTRAINT `keranjang_ibfk_2` FOREIGN KEY (`id_kontak`) REFERENCES `kontak` (`id_kontak`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `keranjang_ibfk_3` FOREIGN KEY (`id_barang`) REFERENCES `barang` (`id_barang`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
DROP TABLE IF EXISTS `kontak`;
CREATE TABLE `kontak` (
  `id_kontak` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `tipe` varchar(255) DEFAULT NULL,
  `grup` varchar(255) DEFAULT NULL,
  `nama` varchar(255) NOT NULL,
  `perusahaan` varchar(255) DEFAULT NULL,
  `alamat` text NOT NULL,
  `telepon` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `nikktp` varchar(16) DEFAULT NULL,
  `npwp` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_kontak`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
INSERT INTO `kontak` (`id_kontak`,`tipe`,`grup`,`nama`,`perusahaan`,`alamat`,`telepon`,`email`,`nikktp`,`npwp`,`created_at`,`updated_at`) VALUES ('1','Pelanggan',NULL,'Umum',NULL,'Bojong','085227058196','member@gmail.com','12314121',NULL,NULL,'2025-10-05 21:12:21'), 
('2','Vendor',NULL,'Aan','Iklip Collections','Tegal','085786811630','sabun@gmail.com','123456789',NULL,'2025-10-05 12:59:50','2025-10-05 21:11:53'), 
('3','Pelanggan',NULL,'Customer',NULL,'Tegal','62812345678','customer@gmail.com','1213151416',NULL,'2025-10-05 12:59:50','2025-10-05 21:13:33'), 
('4','Pelanggan',NULL,'Putri',NULL,'Jakarta','085227265232','Putri@gmail.com','123456789',NULL,'2025-10-05 12:59:50','2025-10-05 21:12:51'), 
('5','Pelanggan',NULL,'Rizqi',NULL,'Bogor','62812345678','Rizqi@gmail.com',NULL,NULL,'2025-10-05 12:59:50','2025-10-05 12:59:50');
DROP TABLE IF EXISTS `login`;
CREATE TABLE `login` (
  `id_login` int(11) NOT NULL AUTO_INCREMENT,
  `email` varchar(255) NOT NULL DEFAULT '',
  `nama` varchar(255) DEFAULT NULL,
  `username` varchar(255) NOT NULL,
  `password` varchar(255) NOT NULL DEFAULT '',
  `id_toko` int(11) NOT NULL DEFAULT 0,
  `token` varchar(255) DEFAULT NULL,
  `role` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 0,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_login`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
INSERT INTO `login` (`id_login`,`email`,`nama`,`username`,`password`,`id_toko`,`token`,`role`,`active`,`created_at`,`updated_at`) VALUES ('1','admin@gmail.com','Administrator','admin','$2y$10$INo6IRmOXz4YqFhdxnzRjuqgKGaOuOlhBpxClF5V8xd1KPnmhq.9G','1',NULL,'1','1',NULL,'2025-10-05 12:59:50'), 
('2','kasir@gmail.com','Kasir','kasir','$2y$10$iTLV.WtmYghGjOSnIHJr8eTF0xFzCJTHOemBLK0tCvlpkeBgOWHk2','1',NULL,'2','1','2025-10-05 12:59:50','2025-10-05 12:59:50'), 
('3','manager@gmail.com','Manager','manager','$2y$10$dKFJw/2EF/ki.lT5dBz6auWJnVqtBeYHbWPUpNaXq28mTAzR328Hq','1',NULL,'3','1','2025-10-05 12:59:50','2025-10-05 12:59:50'), 
('4','sales@gmail.com','Sales','sales','$2y$10$4fagP5P0VulbcRe7Tcyq..WEEszuMgkb2MHOzEe4JjPWSGoywjNxC','1',NULL,'4','1','2025-10-05 12:59:50','2025-10-05 12:59:50'), 
('5','gudang@gmail.com','Gudang','gudang','$2y$10$9fZGZFOqt8bAclgOIvCkcuFUAiL.PSzhrIcWT3n7GmhSg9h6B5y22','1',NULL,'5','1','2025-10-05 12:59:50','2025-10-05 12:59:50');
DROP TABLE IF EXISTS `login_group`;
CREATE TABLE `login_group` (
  `id_login_group` int(11) NOT NULL AUTO_INCREMENT,
  `id_login` int(11) NOT NULL,
  `id_group` int(11) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_login_group`),
  KEY `id_group` (`id_group`),
  KEY `id_login` (`id_login`),
  CONSTRAINT `login_group_ibfk_1` FOREIGN KEY (`id_login`) REFERENCES `login` (`id_login`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `login_group_ibfk_2` FOREIGN KEY (`id_group`) REFERENCES `groups` (`id_group`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
INSERT INTO `login_group` (`id_login_group`,`id_login`,`id_group`,`created_at`,`updated_at`) VALUES ('1','1','1',NULL,NULL), 
('2','2','3',NULL,NULL), 
('3','3','2',NULL,'2025-10-05 15:10:06'), 
('4','4','4',NULL,NULL), 
('5','5','5',NULL,'2025-10-05 15:04:22');
DROP TABLE IF EXISTS `login_log`;
CREATE TABLE `login_log` (
  `id_log_login` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(255) NOT NULL DEFAULT '',
  `username` varchar(255) NOT NULL,
  `loggedin_at` datetime DEFAULT NULL,
  `loggedout_at` datetime DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_log_login`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
INSERT INTO `login_log` (`id_log_login`,`email`,`username`,`loggedin_at`,`loggedout_at`,`created_at`,`updated_at`) VALUES ('1','admin@gmail.com','admin','2025-10-05 03:38:12','2025-10-05 06:43:12','2025-10-05 03:38:12','2025-10-05 06:43:12'), 
('2','admin@gmail.com','admin','2025-10-05 13:42:30','2025-10-05 14:29:36','2025-10-05 13:42:30','2025-10-05 14:29:36'), 
('3','admin@gmail.com','admin','2025-10-05 14:07:49','2025-10-05 19:28:16','2025-10-05 14:07:49','2025-10-05 19:28:16'), 
('4','admin@gmail.com','admin','2025-10-05 19:28:16','2025-10-06 01:45:51','2025-10-05 19:28:16','2025-10-06 01:45:51'), 
('5','admin@gmail.com','admin','2025-10-06 01:45:51','2025-10-06 05:46:27','2025-10-06 01:45:51','2025-10-06 05:46:27'), 
('6','admin@gmail.com','admin','2025-10-06 05:46:27','2025-10-06 05:57:21','2025-10-06 05:46:27','2025-10-06 05:57:21'), 
('7','admin@gmail.com','admin','2025-10-06 06:46:29','2025-10-13 12:39:18','2025-10-06 06:46:29','2025-10-13 12:39:18'), 
('8','admin@gmail.com','admin','2025-10-13 12:39:18','2025-10-13 18:15:08','2025-10-13 12:39:18','2025-10-13 18:15:08'), 
('9','admin@gmail.com','admin','2025-10-13 18:15:08','2025-10-14 05:28:54','2025-10-13 18:15:08','2025-10-14 05:28:54'), 
('10','admin@gmail.com','admin','2025-10-14 05:28:54','2025-10-14 16:58:48','2025-10-14 05:28:54','2025-10-14 16:58:48'), 
('11','admin@gmail.com','admin','2025-10-14 16:58:48','2025-10-15 05:52:32','2025-10-14 16:58:48','2025-10-15 05:52:32'), 
('12','admin@gmail.com','admin','2025-10-15 05:52:32','2025-10-17 19:55:33','2025-10-15 05:52:32','2025-10-17 19:55:33'), 
('13','admin@gmail.com','admin','2025-10-17 19:55:33','2025-11-11 12:12:55','2025-10-17 19:55:33','2025-11-11 12:12:55'), 
('14','admin@gmail.com','admin','2025-11-11 12:12:55','2025-11-11 19:27:21','2025-11-11 12:12:55','2025-11-11 19:27:21'), 
('15','admin@gmail.com','admin','2025-11-11 19:27:21',NULL,'2025-11-11 19:27:21','2025-11-11 19:27:21');
DROP TABLE IF EXISTS `logs`;
CREATE TABLE `logs` (
  `id_log` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `keterangan` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_log`)
) ENGINE=InnoDB AUTO_INCREMENT=165 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
INSERT INTO `logs` (`id_log`,`keterangan`,`created_at`) VALUES ('1','Administrator (admin@gmail.com) melakukan Logout at: 2023-11-04 16:47:52','2023-11-04 16:47:52'), 
('2','Administrator (admin@gmail.com) melakukan Login at: 2025-10-05 03:38:12 on device/s: Windows 10/Firefox 140.0','2025-10-05 03:38:12'), 
('3','Administrator (admin@gmail.com) melakukan Save Backup: db_copos-051025-041729.sql','2025-10-05 04:17:29'), 
('4','Administrator (admin@gmail.com) melakukan Save Open Cashier: 1','2025-10-05 04:26:29'), 
('5','Administrator (admin@gmail.com) melakukan Save Detail Open Cashier: 1','2025-10-05 04:26:29'), 
('6','Administrator (admin@gmail.com) melakukan Logout at: 2025-10-05 06:43:12','2025-10-05 06:43:12'), 
('7','Administrator (admin@gmail.com) melakukan Login at: 2025-10-05 13:42:30 on device/s: Windows 10/Firefox 140.0','2025-10-05 13:42:30'), 
('8','Administrator (admin@gmail.com) melakukan Login at: 2025-10-05 14:07:49 on device/s: Windows 10/Opera 120.0.0.0','2025-10-05 14:07:49'), 
('9','Administrator (admin@gmail.com) melakukan Logout at: 2025-10-05 14:29:36','2025-10-05 14:29:36'), 
('10','Administrator (admin@gmail.com) melakukan Login at: 2025-10-05 19:28:16 on device/s: Windows 10/Firefox 140.0','2025-10-05 19:28:16'), 
('11','Administrator (admin@gmail.com) melakukan Save Kategori: Sabun','2025-10-05 20:41:44'), 
('12','Administrator (admin@gmail.com) melakukan Update Kategori: 5','2025-10-05 20:41:52'), 
('13','Administrator (admin@gmail.com) melakukan Update Kontak: 2','2025-10-05 20:46:04'), 
('14','Administrator (admin@gmail.com) melakukan Save Barang: c2FsbvWSQeBAP5WtfWsh4d','2025-10-05 20:47:50'), 
('15','Administrator (admin@gmail.com) melakukan Update Barang: 1','2025-10-05 20:49:15'), 
('16','Administrator (admin@gmail.com) melakukan Save Barang: TfxszdPjJn2r93q2H28VAe','2025-10-05 20:56:54'), 
('17','Administrator (admin@gmail.com) melakukan Update Barang: 2','2025-10-05 20:57:42'), 
('18','Administrator (admin@gmail.com) melakukan Save Kategori: Bahan Makanan','2025-10-05 21:02:18'), 
('19','Administrator (admin@gmail.com) melakukan Save Barang: 4Ca2y85NED3QXfmDQ6G6wm','2025-10-05 21:04:24'), 
('20','Administrator (admin@gmail.com) melakukan Update Barang: 3','2025-10-05 21:04:49'), 
('21','Administrator (admin@gmail.com) melakukan Save Barang: bBqNHqof5Cg7VExFvmSWtW','2025-10-05 21:08:56'), 
('22','Administrator (admin@gmail.com) melakukan Update Barang: 4','2025-10-05 21:09:53'), 
('23','Administrator (admin@gmail.com) melakukan Update Barang: 4','2025-10-05 21:10:28'), 
('24','Administrator (admin@gmail.com) melakukan Update Kontak: 2','2025-10-05 21:11:53'), 
('25','Administrator (admin@gmail.com) melakukan Update Kontak: 1','2025-10-05 21:12:21'), 
('26','Administrator (admin@gmail.com) melakukan Update Kontak: 4','2025-10-05 21:12:51'), 
('27','Administrator (admin@gmail.com) melakukan Update Kontak: 3','2025-10-05 21:13:33'), 
('28','Administrator (admin@gmail.com) melakukan Login at: 2025-10-06 01:45:51 on device/s: Windows 10/Firefox 140.0','2025-10-06 01:45:51'), 
('29','Administrator (admin@gmail.com) melakukan Save Open Cashier: 2','2025-10-06 01:53:58'), 
('30','Administrator (admin@gmail.com) melakukan Save Detail Open Cashier: 2','2025-10-06 01:53:58'), 
('31','Administrator (admin@gmail.com) melakukan Save Penjualan - Cash: PJ/061025-021220','2025-10-06 02:12:20'), 
('32','Administrator (admin@gmail.com) melakukan Save Cashflow: PJ/061025-021220','2025-10-06 02:12:20'), 
('33','Administrator (admin@gmail.com) melakukan Login at: 2025-10-06 05:46:27 on device/s: Windows 10/Firefox 140.0','2025-10-06 05:46:27'), 
('34','Administrator (admin@gmail.com) melakukan Logout at: 2025-10-06 05:57:21','2025-10-06 05:57:21'), 
('35','Administrator (admin@gmail.com) melakukan Login at: 2025-10-06 06:46:29 on device/s: Windows 10/Firefox 140.0','2025-10-06 06:46:29'), 
('36','Administrator (admin@gmail.com) melakukan Save Open Cashier: 3','2025-10-13 11:00:39'), 
('37','Administrator (admin@gmail.com) melakukan Save Detail Open Cashier: 3','2025-10-13 11:00:39'), 
('38','Administrator (admin@gmail.com) melakukan Save Barang: 4Nh8gohEP2XdMefqRV8ZT9','2025-10-13 11:03:08'), 
('39','Administrator (admin@gmail.com) melakukan Save Barang: Cg7pXtTJXVW4nKwBDLvwKh','2025-10-13 11:05:30'), 
('40','Administrator (admin@gmail.com) melakukan Update active Barang: 6','2025-10-13 11:06:09'), 
('41','Administrator (admin@gmail.com) melakukan Update active Barang: 5','2025-10-13 11:06:11'), 
('42','Administrator (admin@gmail.com) melakukan Update active Barang: 4','2025-10-13 11:06:13'), 
('43','Administrator (admin@gmail.com) melakukan Update active Barang: 4','2025-10-13 11:06:54'), 
('44','Administrator (admin@gmail.com) melakukan Update active Barang: 5','2025-10-13 11:06:59'), 
('45','Administrator (admin@gmail.com) melakukan Update active Barang: 6','2025-10-13 11:07:01'), 
('46','Administrator (admin@gmail.com) melakukan Update active Barang: 3','2025-10-13 11:07:04'), 
('47','Administrator (admin@gmail.com) melakukan Update active Barang: 2','2025-10-13 11:07:06'), 
('48','Administrator (admin@gmail.com) melakukan Save Penjualan - Cash: PJ/131025-110847','2025-10-13 11:08:47'), 
('49','Administrator (admin@gmail.com) melakukan Save Cashflow: PJ/131025-110847','2025-10-13 11:08:47'), 
('50','Administrator (admin@gmail.com) melakukan Logout at: 2025-10-13 12:38:34','2025-10-13 12:38:34'), 
('51','Administrator (admin@gmail.com) melakukan Login at: 2025-10-13 12:39:18 on device/s: Windows 10/Chrome 140.0.0.0','2025-10-13 12:39:18'), 
('52','Administrator (admin@gmail.com) melakukan Save Barang: Q8QxkNSvRoGnhM3PXtTpbT','2025-10-13 12:58:47'), 
('53','Administrator (admin@gmail.com) melakukan Save Penjualan - Cash: PJ/131025-125936','2025-10-13 12:59:36'), 
('54','Administrator (admin@gmail.com) melakukan Save Cashflow: PJ/131025-125936','2025-10-13 12:59:36'), 
('55','Administrator (admin@gmail.com) melakukan Save Penjualan - Cash: PJ/131025-130759','2025-10-13 13:07:59'), 
('56','Administrator (admin@gmail.com) melakukan Save Cashflow: PJ/131025-130759','2025-10-13 13:07:59'), 
('57','Administrator (admin@gmail.com) melakukan Login at: 2025-10-13 18:15:08 on device/s: Windows 10/Chrome 140.0.0.0','2025-10-13 18:15:08'), 
('58','Administrator (admin@gmail.com) melakukan Update Barang: 5','2025-10-13 18:16:41'), 
('59','Administrator (admin@gmail.com) melakukan Save Barang: rb7HAWYfLogXgndMuMD2fF','2025-10-13 18:20:32'), 
('60','Administrator (admin@gmail.com) melakukan Save Barang: RdzbMhwZsmG5xx6uBzZsjN','2025-10-13 18:22:15'), 
('61','Administrator (admin@gmail.com) melakukan Save Barang: VankqocFrfb9w4ZJwxNsJ6','2025-10-13 18:26:48'), 
('62','Administrator (admin@gmail.com) melakukan Save Barang: n7ns4ec5B9NBqeXsFzCXZE','2025-10-13 18:30:05'), 
('63','Administrator (admin@gmail.com) melakukan Save Barang: t5swzuXVjKQXyHQ2Pa4bTL','2025-10-13 18:33:24'), 
('64','Administrator (admin@gmail.com) melakukan Save Barang: MptAhVNCYKcRtEc42WBsC2','2025-10-13 18:36:04'), 
('65','Administrator (admin@gmail.com) melakukan Save Barang: mK47AVvdQWFLQuJmYVfMZY','2025-10-13 18:37:41'), 
('66','Administrator (admin@gmail.com) melakukan Save Barang: wJTdAk4KZZ3Znqo2wKz9rL','2025-10-13 18:39:36'), 
('67','Administrator (admin@gmail.com) melakukan Save Barang: 5MoL7Bd7ocD8fgFxgYe4be','2025-10-13 18:41:07'), 
('68','Administrator (admin@gmail.com) melakukan Save Penjualan - Cash: PJ/131025-184203','2025-10-13 18:42:03'), 
('69','Administrator (admin@gmail.com) melakukan Save Cashflow: PJ/131025-184203','2025-10-13 18:42:03'), 
('70','Administrator (admin@gmail.com) melakukan Save Barang: HtJUTofw6utRfPqrPcseyS','2025-10-13 18:50:27'), 
('71','Administrator (admin@gmail.com) melakukan Update Barang: 17','2025-10-13 18:50:55'), 
('72','Administrator (admin@gmail.com) melakukan Save Barang: oGmBrovE79RiBBmwRFQpMb','2025-10-13 18:52:49'), 
('73','Administrator (admin@gmail.com) melakukan Save Barang: rffLgFT6NZeMKR9cLZj4sK','2025-10-13 18:54:12'), 
('74','Administrator (admin@gmail.com) melakukan Save Barang: HPzBMrmucUgZbFbVX8MQnC','2025-10-13 18:55:35'), 
('75','Administrator (admin@gmail.com) melakukan Save Barang: p5Ei9qd8mxW3QL3VLDRK7H','2025-10-13 18:57:01'), 
('76','Administrator (admin@gmail.com) melakukan Save Barang: yZz4qNnmswtwGAmwED6WuU','2025-10-13 18:58:49'), 
('77','Administrator (admin@gmail.com) melakukan Save Barang: G24T5NUWbXjvjxraE6aQoU','2025-10-13 19:00:40'), 
('78','Administrator (admin@gmail.com) melakukan Save Barang: pgjGsfpi42cE5LRCvhfMGC','2025-10-13 19:02:02'), 
('79','Administrator (admin@gmail.com) melakukan Save Barang: 2fmMMDPVStGFgWk5afXH7R','2025-10-13 19:03:41'), 
('80','Administrator (admin@gmail.com) melakukan Save Barang: ycmu6vYhpFVyvMu2ZjsdoH','2025-10-13 19:07:44'), 
('81','Administrator (admin@gmail.com) melakukan Save Barang: QQmYwyZ8awvm7X5dTAEMcT','2025-10-13 19:09:23'), 
('82','Administrator (admin@gmail.com) melakukan Save Barang: nSqDo3UhviL9Jf4kPnyEaL','2025-10-13 19:12:42'), 
('83','Administrator (admin@gmail.com) melakukan Save Barang: SfA7sVJ7jyDcNeuRYc9p98','2025-10-13 19:14:29'), 
('84','Administrator (admin@gmail.com) melakukan Save Barang: m2WzcedEWapx5qJk9AqiTF','2025-10-13 19:15:53'), 
('85','Administrator (admin@gmail.com) melakukan Save Barang: qdeeqef2kH3NdL6ZGJMzpG','2025-10-13 19:17:08'), 
('86','Administrator (admin@gmail.com) melakukan Save Barang: z65JL2zYeQu9i7csLRo3Dm','2025-10-13 19:18:46'), 
('87','Administrator (admin@gmail.com) melakukan Save Barang: d4xHkVGT5nX5cPoE2hZor9','2025-10-13 19:19:59'), 
('88','Administrator (admin@gmail.com) melakukan Save Barang: yRzAGWXebNKqSMaQD4H3VR','2025-10-13 19:21:20'), 
('89','Administrator (admin@gmail.com) melakukan Save Barang: 8ACFecchcVZUCAtaUjtW7F','2025-10-13 19:22:41'), 
('90','Administrator (admin@gmail.com) melakukan Save Barang: We8d2SBZjE5jDhkkmaXKsZ','2025-10-13 19:24:15'), 
('91','Administrator (admin@gmail.com) melakukan Save Barang: K7kWFtG8GxkedVKMvy6psf','2025-10-13 19:25:44'), 
('92','Administrator (admin@gmail.com) melakukan Save Barang: QFwAC4yGBnDNNXLcmMJe6X','2025-10-13 19:27:01'), 
('93','Administrator (admin@gmail.com) melakukan Save Barang: s57KwsZszwFZGZQCSCVNPb','2025-10-13 19:28:39'), 
('94','Administrator (admin@gmail.com) melakukan Save Barang: wSVUdqXuEAXW2og664kxmh','2025-10-13 19:30:30'), 
('95','Administrator (admin@gmail.com) melakukan Save Barang: EDKvkz4bZzM8kSjSKFwsWS','2025-10-13 19:31:44'), 
('96','Administrator (admin@gmail.com) melakukan Save Barang: i36apcvgdPiA3z5PGbByej','2025-10-13 19:33:18'), 
('97','Administrator (admin@gmail.com) melakukan Save Barang: cnXquomA23TLizYQDJnr9D','2025-10-13 19:34:40'), 
('98','Administrator (admin@gmail.com) melakukan Save Barang: t2JxhSizBpScnX2ecfsH56','2025-10-13 19:36:46'), 
('99','Administrator (admin@gmail.com) melakukan Save Barang: eLhKJWxpXaufWU8prmazSL','2025-10-13 19:40:05'), 
('100','Administrator (admin@gmail.com) melakukan Save Barang: PuTC6pgWtE2T6EvT9hEjYh','2025-10-13 19:41:43'), 
('101','Administrator (admin@gmail.com) melakukan Save Barang: KRwVt7Zpf7h8Nw5PpYkhHa','2025-10-13 19:44:09'), 
('102','Administrator (admin@gmail.com) melakukan Save Barang: QHv6JCmtb5xUaZpRSmc7XX','2025-10-13 19:46:14'), 
('103','Administrator (admin@gmail.com) melakukan Save Barang: afW9wxxrXJirHHHD7zBr2S','2025-10-13 19:48:46'), 
('104','Administrator (admin@gmail.com) melakukan Save Barang: fmaKue8LWoKiAYaKApTJe3','2025-10-13 19:50:49'), 
('105','Administrator (admin@gmail.com) melakukan Update Barang: 48','2025-10-13 19:51:54'), 
('106','Administrator (admin@gmail.com) melakukan Update Barang: 48','2025-10-13 19:52:10'), 
('107','Administrator (admin@gmail.com) melakukan Save Barang: vDidT7yaTexPEdXJYoMmLf','2025-10-13 19:53:46'), 
('108','Administrator (admin@gmail.com) melakukan Save Barang: JnyF8PoXVNK22YyGr97LHU','2025-10-13 20:08:32'), 
('109','Administrator (admin@gmail.com) melakukan Save Barang: LL63DgqasE9tzWAUziQVrN','2025-10-13 20:13:26'), 
('110','Administrator (admin@gmail.com) melakukan Update active Barang: 53','2025-10-13 20:13:47'), 
('111','Administrator (admin@gmail.com) melakukan Save Barang: nDiXHnvE4Z3XvDZvqydBxk','2025-10-13 20:18:00'), 
('112','Administrator (admin@gmail.com) melakukan Save Barang: egLnd9reC3Xfnuvy9pzqxL','2025-10-13 20:22:54'), 
('113','Administrator (admin@gmail.com) melakukan Save Barang: cfdxpJLby26LEqAPazTzp6','2025-10-13 20:26:18'), 
('114','Administrator (admin@gmail.com) melakukan Save Barang: iWMS2KeqDq3mZPd4CNEWF2','2025-10-13 20:30:51'), 
('115','Administrator (admin@gmail.com) melakukan Update Barang: 57','2025-10-13 20:31:59'), 
('116','Administrator (admin@gmail.com) melakukan Update Barang: 56','2025-10-13 20:32:11'), 
('117','Administrator (admin@gmail.com) melakukan Update Barang: 56','2025-10-13 20:32:12'), 
('118','Administrator (admin@gmail.com) melakukan Update Barang: 55','2025-10-13 20:32:19'), 
('119','Administrator (admin@gmail.com) melakukan Update harga_beli Barang: 54','2025-10-13 20:33:01'), 
('120','Administrator (admin@gmail.com) melakukan Update Barang: 57','2025-10-13 20:33:19'), 
('121','Administrator (admin@gmail.com) melakukan Update active Barang: 54','2025-10-13 20:33:54'), 
('122','Administrator (admin@gmail.com) melakukan Save Barang: 7dqxyRBwD5ahFKA4kJywp9','2025-10-13 20:43:32'), 
('123','Administrator (admin@gmail.com) melakukan Save Barang: dhrq5zcPDKAHLZ8MXDaRkg','2025-10-13 20:53:26'), 
('124','Administrator (admin@gmail.com) melakukan Save Barang: RbjSqjALmYZ8GrJfR8vRaH','2025-10-13 21:05:31'), 
('125','Administrator (admin@gmail.com) melakukan Save Barang: X4nXGiaYZNLKuDyiT9pSmS','2025-10-13 21:13:25'), 
('126','Administrator (admin@gmail.com) melakukan Save Barang: hcvc7E6i2wqdnj7ZCsmt5N','2025-10-13 21:16:49'), 
('127','Administrator (admin@gmail.com) melakukan Save Barang: RkXrRgNWAGFUhJsj5nqZ3E','2025-10-13 21:20:34'), 
('128','Administrator (admin@gmail.com) melakukan Save Barang: wRJmBxtP79TT4GUJNFLPoN','2025-10-13 21:25:38'), 
('129','Administrator (admin@gmail.com) melakukan Save Barang: apnFCi6Kzii3FJDcW67GXJ','2025-10-13 21:30:21'), 
('130','Administrator (admin@gmail.com) melakukan Save Barang: Muq5fCAAhU6JqhqFmUSJTb','2025-10-13 21:34:51'), 
('131','Administrator (admin@gmail.com) melakukan Login at: 2025-10-14 05:28:54 on device/s: Windows 10/Chrome 140.0.0.0','2025-10-14 05:28:54'), 
('132','Administrator (admin@gmail.com) melakukan Save Barang: 94K9jVUKq8JgmT6ceZBvzS','2025-10-14 05:34:52'), 
('133','Administrator (admin@gmail.com) melakukan Login at: 2025-10-14 16:58:48 on device/s: Windows 10/Chrome 140.0.0.0','2025-10-14 16:58:48'), 
('134','Administrator (admin@gmail.com) melakukan Login at: 2025-10-15 05:52:32 on device/s: Windows 10/Chrome 140.0.0.0','2025-10-15 05:52:32'), 
('135','Administrator (admin@gmail.com) melakukan Save Open Cashier: 4','2025-10-15 05:53:05'), 
('136','Administrator (admin@gmail.com) melakukan Save Detail Open Cashier: 4','2025-10-15 05:53:05'), 
('137','Administrator (admin@gmail.com) melakukan Save Penjualan - Cash: PJ/151025-061105','2025-10-15 06:11:05'), 
('138','Administrator (admin@gmail.com) melakukan Save Cashflow: PJ/151025-061105','2025-10-15 06:11:05'), 
('139','Administrator (admin@gmail.com) melakukan Save Penjualan - Credit: PJ/151025-061602','2025-10-15 06:16:02'), 
('140','Administrator (admin@gmail.com) melakukan Save Piutang, ID Faktur: 7','2025-10-15 06:16:02'), 
('141','Administrator (admin@gmail.com) melakukan Save Piutang Bayar ID: 1','2025-10-15 06:17:44'), 
('142','Administrator (admin@gmail.com) melakukan Update Piutang ID: 1','2025-10-15 06:17:44'), 
('143','Administrator (admin@gmail.com) melakukan Save Cashflow: PJ/151025-061602','2025-10-15 06:17:44'), 
('144','Administrator (admin@gmail.com) melakukan Update Piutang Bayar ID: 1','2025-10-15 06:17:44'), 
('145','Administrator (admin@gmail.com) melakukan Save Piutang Bayar ID: 2','2025-10-15 06:18:07'), 
('146','Administrator (admin@gmail.com) melakukan Update Piutang ID: 1','2025-10-15 06:18:07'), 
('147','Administrator (admin@gmail.com) melakukan Save Cashflow: PJ/151025-061602','2025-10-15 06:18:07'), 
('148','Administrator (admin@gmail.com) melakukan Update Piutang Bayar ID: 2','2025-10-15 06:18:07'), 
('149','Administrator (admin@gmail.com) melakukan Save Piutang Bayar ID: 3','2025-10-15 06:18:35'), 
('150','Administrator (admin@gmail.com) melakukan Update Piutang ID: 1','2025-10-15 06:18:35'), 
('151','Administrator (admin@gmail.com) melakukan Save Cashflow: PJ/151025-061602','2025-10-15 06:18:35'), 
('152','Administrator (admin@gmail.com) melakukan Update Piutang Bayar ID: 3','2025-10-15 06:18:35'), 
('153','Administrator (admin@gmail.com) melakukan Save Piutang Bayar ID: 4','2025-10-15 06:19:06'), 
('154','Administrator (admin@gmail.com) melakukan Update Piutang ID: 1','2025-10-15 06:19:06'), 
('155','Administrator (admin@gmail.com) melakukan Save Cashflow: PJ/151025-061602','2025-10-15 06:19:06'), 
('156','Administrator (admin@gmail.com) melakukan Update Piutang Bayar ID: 4','2025-10-15 06:19:06'), 
('157','Administrator (admin@gmail.com) melakukan Login at: 2025-10-17 19:55:33 on device/s: Windows 10/Chrome 140.0.0.0','2025-10-17 19:55:33'), 
('158','Administrator (admin@gmail.com) melakukan Login at: 2025-11-11 12:12:55 on device/s: Windows 10/Chrome 141.0.0.0','2025-11-11 12:12:55'), 
('159','Administrator (admin@gmail.com) melakukan Login at: 2025-11-11 19:27:21 on device/s: Windows 10/Chrome 141.0.0.0','2025-11-11 19:27:21'), 
('160','Administrator (admin@gmail.com) melakukan Save Open Cashier: 5','2025-11-11 19:28:39'), 
('161','Administrator (admin@gmail.com) melakukan Save Detail Open Cashier: 5','2025-11-11 19:28:39'), 
('162','Administrator (admin@gmail.com) melakukan Save Penjualan - Cash: PJ/111125-192859','2025-11-11 19:28:59'), 
('163','Administrator (admin@gmail.com) melakukan Save Cashflow: PJ/111125-192859','2025-11-11 19:28:59'), 
('164','Administrator (admin@gmail.com) melakukan Delete Backup: 1','2025-11-11 20:57:44');
DROP TABLE IF EXISTS `media`;
CREATE TABLE `media` (
  `id_media` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `media_path` varchar(255) NOT NULL,
  `id_barang` int(11) unsigned NOT NULL DEFAULT 0,
  `active` int(11) DEFAULT 0,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_media`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
INSERT INTO `media` (`id_media`,`media_path`,`id_barang`,`active`,`created_at`,`updated_at`,`deleted_at`) VALUES ('1','images/1759671528_6a33c01f8be36e38188c.jpg','0','1','2025-10-05 20:38:48','2025-10-05 20:38:48',NULL), 
('2','images/1759672128_fb8d44623179fca006a0.jpg','1','1','2025-10-05 20:48:48','2025-10-05 20:48:48',NULL), 
('3','images/1759672496_0e5ea7ca5b83718893bf.jpg','0','1','2025-10-05 20:54:56','2025-10-05 20:54:56',NULL), 
('4','images/1759672625_a80c643c0e55ba5d857b.jpg','2','1','2025-10-05 20:57:05','2025-10-05 20:57:05',NULL), 
('6','images/1759673074_ea672afecc7fd639bea0.jpg','3','1','2025-10-05 21:04:34','2025-10-05 21:04:34',NULL), 
('7','images/1759673211_942d55ebdbaef9761ba1.jpg','0','1','2025-10-05 21:06:51','2025-10-05 21:06:51',NULL), 
('8','images/1759673409_90223d05e98377b5bd7e.jpg','4','1','2025-10-05 21:10:09','2025-10-05 21:10:09',NULL);
DROP TABLE IF EXISTS `orders`;
CREATE TABLE `orders` (
  `id_order` varchar(20) NOT NULL DEFAULT '',
  `id_barang` int(11) unsigned NOT NULL DEFAULT 0,
  `id_kontak` int(11) unsigned DEFAULT NULL,
  `harga_beli` int(11) NOT NULL DEFAULT 0,
  `harga_jual` int(11) NOT NULL DEFAULT 0,
  `stok` int(11) DEFAULT NULL,
  `qty` int(11) NOT NULL DEFAULT 0,
  `satuan` varchar(255) DEFAULT NULL,
  `jumlah` int(11) NOT NULL DEFAULT 0,
  `id_login` int(11) NOT NULL DEFAULT 0,
  `id_toko` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_order`),
  KEY `id_barang` (`id_barang`),
  CONSTRAINT `orders_ibfk_1` FOREIGN KEY (`id_barang`) REFERENCES `barang` (`id_barang`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
DROP TABLE IF EXISTS `pajak`;
CREATE TABLE `pajak` (
  `id_pajak` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `faktur` varchar(255) DEFAULT NULL,
  `PPN` char(10) DEFAULT '0',
  `jenis` varchar(255) DEFAULT NULL,
  `nominal` int(11) DEFAULT NULL,
  `pembulatan` int(11) NOT NULL DEFAULT 0,
  `keterangan` varchar(255) DEFAULT NULL,
  `id_penjualan` int(11) unsigned DEFAULT NULL,
  `id_toko` int(11) DEFAULT NULL,
  `id_login` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_pajak`),
  KEY `id_penjualan` (`id_penjualan`),
  CONSTRAINT `pajak_ibfk_1` FOREIGN KEY (`id_penjualan`) REFERENCES `penjualan` (`id_penjualan`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
DROP TABLE IF EXISTS `pembelian`;
CREATE TABLE `pembelian` (
  `id_pembelian` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `faktur` varchar(255) DEFAULT NULL,
  `id_kontak` int(11) unsigned DEFAULT NULL,
  `id_login` int(11) NOT NULL DEFAULT 0,
  `id_toko` int(11) DEFAULT NULL,
  `tanggal` date DEFAULT NULL,
  `jatuh_tempo` date DEFAULT NULL,
  `jumlah` int(11) NOT NULL DEFAULT 0,
  `subtotal` int(11) NOT NULL DEFAULT 0,
  `biaya` int(11) NOT NULL DEFAULT 0,
  `total` int(11) NOT NULL DEFAULT 0,
  `status_bayar` int(11) NOT NULL DEFAULT 0,
  `pembayaran` int(11) DEFAULT NULL,
  `catatan` text DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_pembelian`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
DROP TABLE IF EXISTS `pembelian_item`;
CREATE TABLE `pembelian_item` (
  `id_itempembelian` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `id_pembelian` int(11) unsigned DEFAULT NULL,
  `id_barang` int(11) unsigned NOT NULL DEFAULT 0,
  `harga_beli` int(11) DEFAULT NULL,
  `harga_jual` int(11) DEFAULT NULL,
  `qty` int(11) DEFAULT NULL,
  `satuan` varchar(255) DEFAULT NULL,
  `jumlah` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_itempembelian`),
  KEY `id_pembelian` (`id_pembelian`),
  KEY `id_barang` (`id_barang`),
  CONSTRAINT `pembelian_item_ibfk_1` FOREIGN KEY (`id_pembelian`) REFERENCES `pembelian` (`id_pembelian`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `pembelian_item_ibfk_2` FOREIGN KEY (`id_barang`) REFERENCES `barang` (`id_barang`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
DROP TABLE IF EXISTS `penjualan`;
CREATE TABLE `penjualan` (
  `id_penjualan` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `faktur` varchar(255) DEFAULT NULL,
  `id_kontak` int(11) unsigned NOT NULL DEFAULT 0,
  `jumlah` int(11) NOT NULL DEFAULT 0,
  `PPN` char(10) NOT NULL DEFAULT '0',
  `hpp` int(11) NOT NULL DEFAULT 0,
  `subtotal` int(11) NOT NULL DEFAULT 0,
  `diskon` int(11) NOT NULL DEFAULT 0,
  `diskon_persen` int(11) NOT NULL DEFAULT 0,
  `pajak` int(11) NOT NULL DEFAULT 0,
  `pembulatan` int(11) NOT NULL DEFAULT 0,
  `total` int(11) NOT NULL DEFAULT 0,
  `bayar` int(11) NOT NULL DEFAULT 0,
  `kembali` int(11) NOT NULL DEFAULT 0,
  `total_laba` int(11) NOT NULL DEFAULT 0,
  `periode` varchar(255) DEFAULT NULL,
  `id_login` int(11) NOT NULL DEFAULT 0,
  `id_toko` int(11) DEFAULT NULL,
  `metode_bayar` varchar(255) DEFAULT NULL,
  `catatan` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_penjualan`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
INSERT INTO `penjualan` (`id_penjualan`,`faktur`,`id_kontak`,`jumlah`,`PPN`,`hpp`,`subtotal`,`diskon`,`diskon_persen`,`pajak`,`pembulatan`,`total`,`bayar`,`kembali`,`total_laba`,`periode`,`id_login`,`id_toko`,`metode_bayar`,`catatan`,`created_at`,`updated_at`) VALUES ('1','PJ/061025-021220','1','1','0','17000','22700','2000','9','0','0','20700','100000','79300','5700','10-2025','1','1','cash','','2025-10-06 02:12:20',NULL), 
('2','PJ/131025-110847','1','4','0','47500','56200','0','0','0','0','56200','60000','3800','8700','10-2025','1','1','cash','','2025-10-13 11:08:47',NULL), 
('3','PJ/131025-125936','1','3','0','63000','79700','0','0','0','0','79700','80000','300','16700','10-2025','1','1','cash','','2025-10-13 12:59:36',NULL), 
('4','PJ/131025-130759','1','5','0','43000','51300','0','0','0','0','51300','60000','8700','8300','10-2025','1','1','cash','','2025-10-13 13:07:59',NULL), 
('5','PJ/131025-184203','1','3','0','29000','30800','0','0','0','0','30800','50000','19200','1800','10-2025','1','1','cash','','2025-10-13 18:42:03',NULL), 
('6','PJ/151025-061105','1','10','0','189500','218000','6','0','0','0','217994','250000','32006','28500','10-2025','1','1','cash','','2025-10-15 06:11:05',NULL), 
('7','PJ/151025-061602','1','5','0','74000','88200','0','0','0','0','88200','172279','0','14200','10-2025','1','1','credit','','2025-10-15 06:16:02','2025-10-15 06:19:06'), 
('8','PJ/111125-192859','1','2','0','39000','54700','0','0','0','0','54700','54700','0','15700','11-2025','1','1','cash','','2025-11-11 19:28:59',NULL);
DROP TABLE IF EXISTS `penjualan_item`;
CREATE TABLE `penjualan_item` (
  `id_itempenjualan` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `id_barang` int(11) unsigned NOT NULL DEFAULT 0,
  `id_penjualan` int(11) unsigned DEFAULT NULL,
  `harga_beli` int(11) DEFAULT NULL,
  `harga_jual` int(11) DEFAULT NULL,
  `diskon` int(11) NOT NULL DEFAULT 0,
  `diskon_persen` int(11) NOT NULL DEFAULT 0,
  `stok` int(11) DEFAULT NULL,
  `qty` int(11) DEFAULT NULL,
  `satuan` varchar(255) DEFAULT NULL,
  `hpp` int(11) NOT NULL DEFAULT 0,
  `jumlah` int(11) DEFAULT NULL,
  `ppn` int(11) NOT NULL DEFAULT 0,
  `total_laba` int(11) NOT NULL DEFAULT 0,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_itempenjualan`),
  KEY `id_barang` (`id_barang`),
  KEY `id_penjualan` (`id_penjualan`),
  CONSTRAINT `penjualan_item_ibfk_1` FOREIGN KEY (`id_penjualan`) REFERENCES `penjualan` (`id_penjualan`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `penjualan_item_ibfk_2` FOREIGN KEY (`id_barang`) REFERENCES `barang` (`id_barang`)
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
INSERT INTO `penjualan_item` (`id_itempenjualan`,`id_barang`,`id_penjualan`,`harga_beli`,`harga_jual`,`diskon`,`diskon_persen`,`stok`,`qty`,`satuan`,`hpp`,`jumlah`,`ppn`,`total_laba`,`created_at`,`updated_at`) VALUES ('1','4','1','17000','24200','1500','6','150','1','1 kg','17000','22700','0','5700','2025-10-06 02:12:20',NULL), 
('2','2','2','3000','4500','0','0','200','1','1 pcs','3000','4500','0','1500','2025-10-13 11:08:47',NULL), 
('3','6','2','1500','2000','0','0','12','1','1 pcs','1500','2000','0','500','2025-10-13 11:08:47',NULL), 
('4','5','2','26000','27000','0','0','12','1','1 bungkus','26000','27000','0','1000','2025-10-13 11:08:47',NULL), 
('5','4','2','17000','24200','1500','6','149','1','1 kg','17000','22700','0','5700','2025-10-13 11:08:47',NULL), 
('6','4','3','17000','24200','1500','6','148','1','1 kg','17000','22700','0','5700','2025-10-13 12:59:36',NULL), 
('7','1','3','20000','32000','2000','6','500','1','8 pcs','20000','30000','0','10000','2025-10-13 12:59:36',NULL), 
('8','5','3','26000','27000','0','0','11','1','1 bungkus','26000','27000','0','1000','2025-10-13 12:59:36',NULL), 
('9','3','4','11000','16000','0','0','100','1','1 gram','11000','16000','0','5000','2025-10-13 13:07:59',NULL), 
('10','5','4','26000','27000','0','0','10','1','1 bungkus','26000','27000','0','1000','2025-10-13 13:07:59',NULL), 
('11','6','4','1500','2000','0','0','11','1','1 pcs','1500','2000','0','500','2025-10-13 13:07:59',NULL), 
('12','2','4','3000','4500','0','0','199','1','1 pcs','3000','4500','0','1500','2025-10-13 13:07:59',NULL), 
('13','7','4','1500','2000','200','10','12','1','1 pcs','1500','1800','0','300','2025-10-13 13:07:59',NULL), 
('14','5','5','26000','27000','0','0','9','1','1 bungkus','26000','27000','0','1000','2025-10-13 18:42:03',NULL), 
('15','6','5','1500','2000','0','0','10','1','1 pcs','1500','2000','0','500','2025-10-13 18:42:03',NULL), 
('16','7','5','1500','2000','200','10','11','1','1 pcs','1500','1800','0','300','2025-10-13 18:42:03',NULL), 
('17','1','6','20000','32000','2000','6','499','1','8 pcs','20000','30000','0','10000','2025-10-15 06:11:05',NULL), 
('18','2','6','3000','4500','0','0','198','1','1 pcs','3000','4500','0','1500','2025-10-15 06:11:05',NULL), 
('19','3','6','11000','16000','0','0','99','1','1 gram','11000','16000','0','5000','2025-10-15 06:11:05',NULL), 
('20','4','6','17000','24200','1500','6','147','1','1 kg','17000','22700','0','5700','2025-10-15 06:11:05',NULL), 
('21','5','6','26000','27000','0','0','8','2','1 bungkus','52000','54000','0','2000','2025-10-15 06:11:05',NULL), 
('22','7','6','1500','2000','200','10','10','1','1 pcs','1500','1800','0','300','2025-10-15 06:11:05',NULL), 
('23','9','6','29000','30000','0','0','100','1','1 bungkus','29000','30000','0','1000','2025-10-15 06:11:05',NULL), 
('24','10','6','17000','18000','0','0','100','1','1 bungkus','17000','18000','0','1000','2025-10-15 06:11:05',NULL), 
('25','12','6','15000','16000','0','0','100','1','1 bungkus','15000','16000','0','1000','2025-10-15 06:11:05',NULL), 
('26','19','6','24000','25000','0','0','100','1','1 bungkus','24000','25000','0','1000','2025-10-15 06:11:05',NULL), 
('27','2','7','3000','4500','0','0','197','1','1 pcs','3000','4500','0','1500','2025-10-15 06:16:02',NULL), 
('28','3','7','11000','16000','0','0','98','1','1 gram','11000','16000','0','5000','2025-10-15 06:16:02',NULL), 
('29','4','7','17000','24200','1500','6','146','1','1 kg','17000','22700','0','5700','2025-10-15 06:16:02',NULL), 
('30','5','7','26000','27000','0','0','6','1','1 bungkus','26000','27000','0','1000','2025-10-15 06:16:02',NULL), 
('31','10','7','17000','18000','0','0','99','1','1 bungkus','17000','18000','0','1000','2025-10-15 06:16:02',NULL), 
('32','3','8','11000','16000','0','0','97','2','1 gram','22000','32000','0','10000','2025-11-11 19:28:59',NULL), 
('33','4','8','17000','24200','1500','6','145','1','1 kg','17000','22700','0','5700','2025-11-11 19:28:59',NULL);
DROP TABLE IF EXISTS `piutang`;
CREATE TABLE `piutang` (
  `id_piutang` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `id_penjualan` int(11) unsigned NOT NULL,
  `tanggal` date DEFAULT NULL,
  `jatuh_tempo` date DEFAULT NULL,
  `jumlah_piutang` int(11) DEFAULT NULL,
  `jumlah_bayar` int(11) DEFAULT NULL,
  `sisa_piutang` int(11) DEFAULT NULL,
  `status_piutang` int(11) NOT NULL DEFAULT 0,
  `keterangan` varchar(255) DEFAULT NULL,
  `id_login` int(11) NOT NULL DEFAULT 0,
  `id_toko` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_piutang`),
  KEY `id_penjualan` (`id_penjualan`),
  KEY `id_login` (`id_login`),
  KEY `id_toko` (`id_toko`),
  CONSTRAINT `piutang_ibfk_1` FOREIGN KEY (`id_penjualan`) REFERENCES `penjualan` (`id_penjualan`),
  CONSTRAINT `piutang_ibfk_2` FOREIGN KEY (`id_login`) REFERENCES `login` (`id_login`),
  CONSTRAINT `piutang_ibfk_3` FOREIGN KEY (`id_toko`) REFERENCES `toko` (`id_toko`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
INSERT INTO `piutang` (`id_piutang`,`id_penjualan`,`tanggal`,`jatuh_tempo`,`jumlah_piutang`,`jumlah_bayar`,`sisa_piutang`,`status_piutang`,`keterangan`,`id_login`,`id_toko`,`created_at`,`updated_at`) VALUES ('1','7','2025-10-15','2025-10-18','88200','88200','0','1','diki hutang bayaar tahun depan','1','1','2025-10-15 06:16:02','2025-10-15 06:19:06');
DROP TABLE IF EXISTS `piutang_bayar`;
CREATE TABLE `piutang_bayar` (
  `id_piutang_bayar` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `id_piutang` int(11) unsigned NOT NULL DEFAULT 0,
  `nominal` int(11) DEFAULT NULL,
  `id_cashflow` int(11) unsigned NOT NULL DEFAULT 0,
  `id_login` int(11) NOT NULL DEFAULT 0,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_piutang_bayar`),
  KEY `id_piutang` (`id_piutang`),
  CONSTRAINT `piutang_bayar_ibfk_1` FOREIGN KEY (`id_piutang`) REFERENCES `piutang` (`id_piutang`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
INSERT INTO `piutang_bayar` (`id_piutang_bayar`,`id_piutang`,`nominal`,`id_cashflow`,`id_login`,`created_at`,`updated_at`) VALUES ('1','1','5000','7','1','2025-10-15 06:17:44','2025-10-15 06:17:44'), 
('2','1','79','8','1','2025-10-15 06:18:07','2025-10-15 06:18:07'), 
('3','1','79000','9','1','2025-10-15 06:18:35','2025-10-15 06:18:35'), 
('4','1','4121','10','1','2025-10-15 06:19:06','2025-10-15 06:19:06');
DROP TABLE IF EXISTS `satuan`;
CREATE TABLE `satuan` (
  `id_satuan` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `nama_satuan` varchar(255) NOT NULL DEFAULT '',
  `nilai_satuan` int(11) NOT NULL DEFAULT 0,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_satuan`),
  KEY `nama_satuan` (`nama_satuan`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
INSERT INTO `satuan` (`id_satuan`,`nama_satuan`,`nilai_satuan`,`created_at`,`updated_at`) VALUES ('1','pcs','1',NULL,NULL), 
('2','buah','1',NULL,NULL), 
('3','butir','1',NULL,NULL), 
('4','bungkus','1','2025-10-05 12:59:50','2025-10-05 12:59:50'), 
('5','gram','100',NULL,NULL), 
('6','kg','1',NULL,NULL), 
('7','roll','1',NULL,NULL), 
('8','lembar','1',NULL,NULL);
DROP TABLE IF EXISTS `settings`;
CREATE TABLE `settings` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `group_setting` varchar(100) NOT NULL,
  `variable_setting` varchar(255) NOT NULL,
  `value_setting` text NOT NULL,
  `deskripsi_setting` varchar(255) NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
INSERT INTO `settings` (`id`,`group_setting`,`variable_setting`,`value_setting`,`deskripsi_setting`,`updated_at`) VALUES ('1','general','app_name','Toko Cahaya Berkah','App Name','2025-10-05 06:16:12'), 
('2','general','app_version','1','App Version','2025-10-05 18:22:10'), 
('3','general','app_release','2025-10-05 08:24:55','App Release','2025-10-05 08:24:55'), 
('4','general','app_developer','Toko Cahaya Berkah','App Developer','2025-10-05 17:05:03'), 
('5','image','img_favicon','assets/images/favicon.png','Favicon','2025-10-05 13:14:59'), 
('6','image','img_logo','assets/images/logo.png','Logo','2025-10-05 09:47:27'), 
('7','image','img_logo_resize','assets/images/res_logo.png','Logo Resized','2025-10-05 09:47:28'), 
('8','image','img_background','assets/images/background.jpg','Background','2025-10-05 13:17:10'), 
('9','app','snackbars_position','bottom','Posisi Snackbars Notification','2025-10-05 07:22:22'), 
('10','app','limit_loginlog','2000','Limit Login Log (default 2000)','2025-10-05 08:24:55'), 
('11','app','enable_frontend','true','Tampilkan Home atau Halaman Login','2025-10-05 18:22:33'), 
('12','app','cashierpay_position','left','Posisi Tombol Pay Kasir','2025-10-05 13:18:48');
DROP TABLE IF EXISTS `shift`;
CREATE TABLE `shift` (
  `id_shift` int(11) NOT NULL AUTO_INCREMENT,
  `nama_shift` varchar(255) DEFAULT NULL,
  `jam_mulai` time DEFAULT NULL,
  `jam_selesai` time DEFAULT NULL,
  `id_toko` int(11) NOT NULL DEFAULT 0,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_shift`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;
INSERT INTO `shift` (`id_shift`,`nama_shift`,`jam_mulai`,`jam_selesai`,`id_toko`,`created_at`,`updated_at`) VALUES ('1','Shift 1','07:00:00','15:00:00','1',NULL,'2025-10-05 12:59:50'), 
('2','Shift 2','15:00:00','21:00:00','1',NULL,'2025-10-05 12:59:50'), 
('3','Shift 3','00:00:00','00:00:00','1',NULL,NULL), 
('4',NULL,NULL,NULL,'1',NULL,NULL), 
('5',NULL,NULL,NULL,'1',NULL,NULL);
DROP TABLE IF EXISTS `shift_openclose`;
CREATE TABLE `shift_openclose` (
  `id_shift_openclose` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `id_shift` int(11) NOT NULL,
  `type` char(20) DEFAULT NULL,
  `tanggal` date DEFAULT NULL,
  `waktu` time DEFAULT NULL,
  `id_login` int(11) NOT NULL DEFAULT 0,
  `supervisor` int(11) NOT NULL DEFAULT 0,
  `jumlah_uang_kertas` int(11) DEFAULT NULL,
  `jumlah_uang_koin` int(11) DEFAULT NULL,
  `id_toko` int(11) NOT NULL DEFAULT 0,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_shift_openclose`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;
INSERT INTO `shift_openclose` (`id_shift_openclose`,`id_shift`,`type`,`tanggal`,`waktu`,`id_login`,`supervisor`,`jumlah_uang_kertas`,`jumlah_uang_koin`,`id_toko`,`created_at`,`updated_at`) VALUES ('1','1','open','2025-10-05','04:18:00','1','3','950000','50000','1','2025-10-05 04:26:29','2025-10-05 04:26:29'), 
('2','3','open','2025-10-06','01:51:00','1','3','500000','0','1','2025-10-06 01:53:58','2025-10-06 01:53:58'), 
('3','1','open','2025-10-13','11:00:00','1','3','0','0','1','2025-10-13 11:00:39','2025-10-13 11:00:39'), 
('4','1','open','2025-10-15','05:52:00','1','3','0','0','1','2025-10-15 05:53:05','2025-10-15 05:53:05'), 
('5','2','open','2025-11-11','19:28:00','1','3','0','0','1','2025-11-11 19:28:39','2025-11-11 19:28:39');
DROP TABLE IF EXISTS `shift_openclose_detail`;
CREATE TABLE `shift_openclose_detail` (
  `id_shift_openclose_detail` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `id_shift_openclose` int(11) unsigned NOT NULL,
  `kertas100` int(11) NOT NULL DEFAULT 0,
  `kertas50` int(11) NOT NULL DEFAULT 0,
  `kertas20` int(11) NOT NULL DEFAULT 0,
  `kertas10` int(11) NOT NULL DEFAULT 0,
  `kertas5` int(11) NOT NULL DEFAULT 0,
  `kertas2` int(11) NOT NULL DEFAULT 0,
  `kertas1` int(11) NOT NULL DEFAULT 0,
  `koin1000` int(11) NOT NULL DEFAULT 0,
  `koin500` int(11) NOT NULL DEFAULT 0,
  `koin200` int(11) NOT NULL DEFAULT 0,
  `koin100` int(11) NOT NULL DEFAULT 0,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_shift_openclose_detail`),
  KEY `id_shift_openclose` (`id_shift_openclose`),
  CONSTRAINT `shift_openclose_detail_ibfk_1` FOREIGN KEY (`id_shift_openclose`) REFERENCES `shift_openclose` (`id_shift_openclose`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;
INSERT INTO `shift_openclose_detail` (`id_shift_openclose_detail`,`id_shift_openclose`,`kertas100`,`kertas50`,`kertas20`,`kertas10`,`kertas5`,`kertas2`,`kertas1`,`koin1000`,`koin500`,`koin200`,`koin100`,`created_at`,`updated_at`) VALUES ('1','1','3','4','5','10','20','50','50','20','20','50','100','2025-10-05 04:26:29','2025-10-05 04:26:29'), 
('2','2','4','1','0','0','0','0','50','0','0','0','0','2025-10-06 01:53:58','2025-10-06 01:53:58'), 
('3','3','0','0','0','0','0','0','0','0','0','0','0','2025-10-13 11:00:39','2025-10-13 11:00:39'), 
('4','4','0','0','0','0','0','0','0','0','0','0','0','2025-10-15 05:53:05','2025-10-15 05:53:05'), 
('5','5','0','0','0','0','0','0','0','0','0','0','0','2025-11-11 19:28:39','2025-11-11 19:28:39');
DROP TABLE IF EXISTS `stok`;
CREATE TABLE `stok` (
  `id_stok` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `id_barang` int(11) unsigned NOT NULL DEFAULT 0,
  `jenis` varchar(255) DEFAULT NULL,
  `jumlah` varchar(255) DEFAULT NULL,
  `nilai` varchar(255) DEFAULT NULL,
  `keterangan` varchar(255) DEFAULT NULL,
  `id_toko` int(11) DEFAULT NULL,
  `id_login` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_stok`),
  KEY `id_barang` (`id_barang`),
  CONSTRAINT `stok_ibfk_1` FOREIGN KEY (`id_barang`) REFERENCES `barang` (`id_barang`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `stok_opname`;
CREATE TABLE `stok_opname` (
  `id_stok_opname` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `id_barang` int(11) unsigned NOT NULL DEFAULT 0,
  `stok` int(11) DEFAULT NULL,
  `stok_nyata` int(11) DEFAULT NULL,
  `selisih` varchar(255) DEFAULT NULL,
  `nilai` varchar(255) DEFAULT NULL,
  `keterangan` varchar(255) DEFAULT NULL,
  `id_toko` int(11) DEFAULT NULL,
  `id_login` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_stok_opname`),
  KEY `id_barang` (`id_barang`),
  CONSTRAINT `stok_opname_ibfk_1` FOREIGN KEY (`id_barang`) REFERENCES `barang` (`id_barang`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `toko`;
CREATE TABLE `toko` (
  `id_toko` int(11) NOT NULL AUTO_INCREMENT,
  `nama_toko` varchar(255) NOT NULL,
  `alamat_toko` text NOT NULL,
  `telp` varchar(255) NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `nama_pemilik` varchar(255) NOT NULL,
  `NIB` char(15) DEFAULT NULL,
  `PPN` char(10) DEFAULT '0',
  `include_ppn` int(11) NOT NULL DEFAULT 0,
  `kode_barang` varchar(255) DEFAULT NULL,
  `kode_jual` varchar(255) DEFAULT NULL,
  `kode_jual_tahun` int(11) DEFAULT 0,
  `kode_beli` varchar(255) DEFAULT NULL,
  `kode_kas` varchar(255) DEFAULT NULL,
  `kode_bank` varchar(255) DEFAULT NULL,
  `kode_pajak` varchar(255) DEFAULT NULL,
  `kode_biaya` varchar(255) DEFAULT NULL,
  `paper_size` char(10) DEFAULT '0',
  `footer_nota` varchar(255) DEFAULT NULL,
  `printer_usb` int(11) DEFAULT 0,
  `printer_bluetooth` int(11) DEFAULT 0,
  `scan_keranjang` int(11) DEFAULT 0,
  `id_bank_akun` int(11) NOT NULL DEFAULT 0,
  `jatuhtempo_hari_tanggal` int(11) NOT NULL DEFAULT 0,
  `jatuhtempo_keterangan` int(11) NOT NULL DEFAULT 0,
  `jatuhtempo_hari` int(11) NOT NULL DEFAULT 0,
  `jatuhtempo_tanggal` int(11) NOT NULL DEFAULT 0,
  `pembulatan` int(11) NOT NULL DEFAULT 0,
  `pembulatan_keatas` int(11) NOT NULL DEFAULT 0,
  `pembulatan_max` int(11) NOT NULL DEFAULT 0,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_toko`),
  KEY `id_bank_akun` (`id_bank_akun`),
  CONSTRAINT `toko_ibfk_1` FOREIGN KEY (`id_bank_akun`) REFERENCES `bank_akun` (`id_bank_akun`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
INSERT INTO `toko` (`id_toko`,`nama_toko`,`alamat_toko`,`telp`,`email`,`nama_pemilik`,`NIB`,`PPN`,`include_ppn`,`kode_barang`,`kode_jual`,`kode_jual_tahun`,`kode_beli`,`kode_kas`,`kode_bank`,`kode_pajak`,`kode_biaya`,`paper_size`,`footer_nota`,`printer_usb`,`printer_bluetooth`,`scan_keranjang`,`id_bank_akun`,`jatuhtempo_hari_tanggal`,`jatuhtempo_keterangan`,`jatuhtempo_hari`,`jatuhtempo_tanggal`,`pembulatan`,`pembulatan_keatas`,`pembulatan_max`,`updated_at`) VALUES ('1','Toko Cahaya Berkah','Bojong RT 01 Rw 05','088289729445','akhyinamuazzi@gmail.com','Akhyina Muazzi','012345678','0','0','BRG-','PJ/','1','PI/','KAS/','BANK/','PPN/','BYA/','58','Terima kasih sudah berbelanja, Barang yang sudah dibeli tidak dapat dikembalikan','1','1','1','2','0','1','3','20','1','1','100','2025-10-05 06:51:44');
SET FOREIGN_KEY_CHECKS=1;
