SET FOREIGN_KEY_CHECKS=0;
DROP TABLE IF EXISTS `backups`;
CREATE TABLE `backups` (
  `id_backup` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `file_name` varchar(255) DEFAULT NULL,
  `file_path` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_backup`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
DROP TABLE IF EXISTS `bank`;
CREATE TABLE `bank` (
  `id_bank` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `faktur` varchar(255) DEFAULT NULL,
  `jenis` varchar(255) DEFAULT NULL,
  `tanggal` date DEFAULT NULL,
  `waktu` time DEFAULT NULL,
  `pemasukan` int(11) DEFAULT NULL,
  `pengeluaran` int(11) DEFAULT NULL,
  `keterangan` varchar(255) DEFAULT NULL,
  `id_penjualan` int(11) unsigned DEFAULT NULL,
  `noref_nokartu` varchar(255) DEFAULT NULL,
  `id_toko` int(11) DEFAULT NULL,
  `id_login` int(11) DEFAULT NULL,
  `id_bank_akun` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_bank`),
  KEY `id_login` (`id_login`),
  KEY `id_toko` (`id_toko`),
  KEY `id_bank_akun` (`id_bank_akun`),
  KEY `id_penjualan` (`id_penjualan`),
  CONSTRAINT `bank_ibfk_1` FOREIGN KEY (`id_login`) REFERENCES `login` (`id_login`),
  CONSTRAINT `bank_ibfk_2` FOREIGN KEY (`id_toko`) REFERENCES `toko` (`id_toko`),
  CONSTRAINT `bank_ibfk_3` FOREIGN KEY (`id_bank_akun`) REFERENCES `bank_akun` (`id_bank_akun`),
  CONSTRAINT `bank_ibfk_4` FOREIGN KEY (`id_penjualan`) REFERENCES `penjualan` (`id_penjualan`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
DROP TABLE IF EXISTS `bank_akun`;
CREATE TABLE `bank_akun` (
  `id_bank_akun` int(11) NOT NULL AUTO_INCREMENT,
  `nama_bank` varchar(255) DEFAULT NULL,
  `bank_nama` varchar(255) DEFAULT NULL,
  `no_rekening` varchar(255) DEFAULT NULL,
  `utama` int(11) NOT NULL DEFAULT 0,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_bank_akun`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;
INSERT INTO `bank_akun` (`id_bank_akun`,`nama_bank`,`bank_nama`,`no_rekening`,`utama`,`created_at`,`updated_at`) VALUES ('1','BANK 1, Purwokerto','John Doe','123456789','0',NULL,'2023-10-14 06:51:44'), 
('2','Shopeepay','Shopeepay','08123456789','1','2023-10-14 06:48:45','2023-10-14 06:51:44');
DROP TABLE IF EXISTS `barang`;
CREATE TABLE `barang` (
  `id_barang` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `uuid_barang` char(36) NOT NULL DEFAULT '',
  `kode_barang` varchar(255) DEFAULT NULL,
  `barcode` varchar(255) DEFAULT NULL,
  `id_kategori` int(11) unsigned NOT NULL DEFAULT 0,
  `id_kontak` int(11) unsigned DEFAULT NULL,
  `sku` varchar(255) DEFAULT NULL,
  `nama_barang` varchar(255) NOT NULL DEFAULT '',
  `merk` varchar(255) NOT NULL,
  `harga_beli` int(11) NOT NULL DEFAULT 0,
  `diskon` int(11) NOT NULL DEFAULT 0,
  `diskon_persen` int(11) NOT NULL DEFAULT 0,
  `harga_jual` int(11) NOT NULL DEFAULT 0,
  `harga_pelanggan` int(11) NOT NULL DEFAULT 0,
  `harga_sales` int(11) NOT NULL DEFAULT 0,
  `range_harga` varchar(255) DEFAULT NULL,
  `satuan_barang` varchar(255) NOT NULL,
  `satuan_nilai` int(11) NOT NULL DEFAULT 0,
  `deskripsi` text DEFAULT NULL,
  `stok` int(11) NOT NULL DEFAULT 0,
  `stok_min` int(11) NOT NULL DEFAULT 0,
  `stok_gudang` int(11) NOT NULL DEFAULT 0,
  `expired` datetime DEFAULT NULL,
  `active` int(11) DEFAULT 0,
  `id_toko` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_barang`),
  KEY `id_kategori` (`id_kategori`),
  CONSTRAINT `barang_ibfk_1` FOREIGN KEY (`id_kategori`) REFERENCES `kategori` (`id_kategori`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `biaya`;
CREATE TABLE `biaya` (
  `id_biaya` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `faktur` varchar(255) DEFAULT NULL,
  `tanggal` date DEFAULT NULL,
  `waktu` time DEFAULT NULL,
  `jenis` varchar(255) DEFAULT NULL,
  `nominal` int(11) NOT NULL DEFAULT 0,
  `keterangan` varchar(255) DEFAULT NULL,
  `id_toko` int(11) DEFAULT NULL,
  `id_login` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_biaya`),
  KEY `id_toko` (`id_toko`),
  KEY `id_login` (`id_login`),
  CONSTRAINT `biaya_ibfk_1` FOREIGN KEY (`id_toko`) REFERENCES `toko` (`id_toko`),
  CONSTRAINT `biaya_ibfk_2` FOREIGN KEY (`id_login`) REFERENCES `login` (`id_login`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `cashflow`;
CREATE TABLE `cashflow` (
  `id_cashflow` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `faktur` varchar(255) DEFAULT NULL,
  `jenis` varchar(255) DEFAULT NULL,
  `kategori` varchar(255) DEFAULT NULL,
  `tanggal` date DEFAULT NULL,
  `waktu` time DEFAULT NULL,
  `pemasukan` int(11) NOT NULL DEFAULT 0,
  `pengeluaran` int(11) NOT NULL DEFAULT 0,
  `keterangan` varchar(255) DEFAULT NULL,
  `id_penjualan` int(11) unsigned DEFAULT NULL,
  `id_pembelian` int(11) unsigned DEFAULT NULL,
  `id_biaya` int(11) unsigned DEFAULT NULL,
  `id_toko` int(11) DEFAULT NULL,
  `id_login` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_cashflow`),
  KEY `id_penjualan` (`id_penjualan`),
  KEY `id_pembelian` (`id_pembelian`),
  KEY `id_biaya` (`id_biaya`),
  KEY `id_toko` (`id_toko`),
  KEY `id_login` (`id_login`),
  CONSTRAINT `cashflow_ibfk_1` FOREIGN KEY (`id_penjualan`) REFERENCES `penjualan` (`id_penjualan`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `cashflow_ibfk_2` FOREIGN KEY (`id_pembelian`) REFERENCES `pembelian` (`id_pembelian`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `cashflow_ibfk_3` FOREIGN KEY (`id_biaya`) REFERENCES `biaya` (`id_biaya`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `cashflow_ibfk_4` FOREIGN KEY (`id_toko`) REFERENCES `toko` (`id_toko`),
  CONSTRAINT `cashflow_ibfk_5` FOREIGN KEY (`id_login`) REFERENCES `login` (`id_login`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `groups`;
CREATE TABLE `groups` (
  `id_group` int(11) NOT NULL AUTO_INCREMENT,
  `nama_group` varchar(255) NOT NULL,
  `permission` text NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_group`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
INSERT INTO `groups` (`id_group`,`nama_group`,`permission`,`created_at`,`updated_at`) VALUES ('1','Administrator','a:84:{i:0;s:13:\"viewDashboard\";i:1;s:13:\"menuDashboard\";i:2;s:10:\"menuBarang\";i:3;s:10:\"viewBarang\";i:4;s:12:\"createBarang\";i:5;s:12:\"updateBarang\";i:6;s:12:\"deleteBarang\";i:7;s:9:\"viewExcel\";i:8;s:11:\"createExcel\";i:9;s:13:\"viewStokInOut\";i:10;s:15:\"createStokInOut\";i:11;s:15:\"updateStokInOut\";i:12;s:15:\"deleteStokInOut\";i:13;s:14:\"viewStokOpname\";i:14;s:16:\"createStokOpname\";i:15;s:16:\"updateStokOpname\";i:16;s:16:\"deleteStokOpname\";i:17;s:13:\"menuTransaksi\";i:18;s:13:\"viewPenjualan\";i:19;s:15:\"createPenjualan\";i:20;s:15:\"updatePenjualan\";i:21;s:15:\"deletePenjualan\";i:22;s:13:\"viewPembelian\";i:23;s:15:\"createPembelian\";i:24;s:15:\"updatePembelian\";i:25;s:15:\"deletePembelian\";i:26;s:10:\"viewHutang\";i:27;s:12:\"createHutang\";i:28;s:12:\"updateHutang\";i:29;s:12:\"deleteHutang\";i:30;s:11:\"viewPiutang\";i:31;s:13:\"createPiutang\";i:32;s:13:\"updatePiutang\";i:33;s:13:\"deletePiutang\";i:34;s:9:\"viewBiaya\";i:35;s:11:\"createBiaya\";i:36;s:11:\"updateBiaya\";i:37;s:11:\"deleteBiaya\";i:38;s:12:\"menuKeuangan\";i:39;s:12:\"viewCashflow\";i:40;s:14:\"createCashflow\";i:41;s:14:\"updateCashflow\";i:42;s:14:\"deleteCashflow\";i:43;s:8:\"viewBank\";i:44;s:10:\"createBank\";i:45;s:10:\"updateBank\";i:46;s:10:\"deleteBank\";i:47;s:9:\"viewPajak\";i:48;s:11:\"createPajak\";i:49;s:11:\"updatePajak\";i:50;s:11:\"deletePajak\";i:51;s:10:\"menuKontak\";i:52;s:10:\"viewKontak\";i:53;s:12:\"createKontak\";i:54;s:12:\"updateKontak\";i:55;s:12:\"deleteKontak\";i:56;s:8:\"menuUser\";i:57;s:8:\"viewUser\";i:58;s:10:\"createUser\";i:59;s:10:\"updateUser\";i:60;s:10:\"deleteUser\";i:61;s:9:\"viewGroup\";i:62;s:11:\"createGroup\";i:63;s:11:\"updateGroup\";i:64;s:11:\"deleteGroup\";i:65;s:11:\"menuSetting\";i:66;s:11:\"viewSetting\";i:67;s:13:\"updateSetting\";i:68;s:10:\"viewConfig\";i:69;s:12:\"updateConfig\";i:70;s:12:\"viewBankAkun\";i:71;s:14:\"createBankAkun\";i:72;s:14:\"updateBankAkun\";i:73;s:14:\"deleteBankAkun\";i:74;s:10:\"viewBackup\";i:75;s:12:\"createBackup\";i:76;s:12:\"deleteBackup\";i:77;s:11:\"viewLaporan\";i:78;s:11:\"menuLaporan\";i:79;s:19:\"viewLaporanLabaRugi\";i:80;s:13:\"viewStatistik\";i:81;s:13:\"menuStatistik\";i:82;s:11:\"updateShift\";i:83;s:11:\"deleteShift\";}',NULL,'2023-05-06 10:53:03'), 
('2','Manager','a:84:{i:0;s:13:\"viewDashboard\";i:1;s:13:\"menuDashboard\";i:2;s:10:\"menuBarang\";i:3;s:10:\"viewBarang\";i:4;s:12:\"createBarang\";i:5;s:12:\"updateBarang\";i:6;s:12:\"deleteBarang\";i:7;s:9:\"viewExcel\";i:8;s:11:\"createExcel\";i:9;s:13:\"viewStokInOut\";i:10;s:15:\"createStokInOut\";i:11;s:15:\"updateStokInOut\";i:12;s:15:\"deleteStokInOut\";i:13;s:14:\"viewStokOpname\";i:14;s:16:\"createStokOpname\";i:15;s:16:\"updateStokOpname\";i:16;s:16:\"deleteStokOpname\";i:17;s:13:\"menuTransaksi\";i:18;s:13:\"viewPenjualan\";i:19;s:15:\"createPenjualan\";i:20;s:15:\"updatePenjualan\";i:21;s:15:\"deletePenjualan\";i:22;s:13:\"viewPembelian\";i:23;s:15:\"createPembelian\";i:24;s:15:\"updatePembelian\";i:25;s:15:\"deletePembelian\";i:26;s:10:\"viewHutang\";i:27;s:12:\"createHutang\";i:28;s:12:\"updateHutang\";i:29;s:12:\"deleteHutang\";i:30;s:11:\"viewPiutang\";i:31;s:13:\"createPiutang\";i:32;s:13:\"updatePiutang\";i:33;s:13:\"deletePiutang\";i:34;s:9:\"viewBiaya\";i:35;s:11:\"createBiaya\";i:36;s:11:\"updateBiaya\";i:37;s:11:\"deleteBiaya\";i:38;s:12:\"menuKeuangan\";i:39;s:12:\"viewCashflow\";i:40;s:14:\"createCashflow\";i:41;s:14:\"updateCashflow\";i:42;s:14:\"deleteCashflow\";i:43;s:8:\"viewBank\";i:44;s:10:\"createBank\";i:45;s:10:\"updateBank\";i:46;s:10:\"deleteBank\";i:47;s:9:\"viewPajak\";i:48;s:11:\"createPajak\";i:49;s:11:\"updatePajak\";i:50;s:11:\"deletePajak\";i:51;s:10:\"menuKontak\";i:52;s:10:\"viewKontak\";i:53;s:12:\"createKontak\";i:54;s:12:\"updateKontak\";i:55;s:12:\"deleteKontak\";i:56;s:8:\"menuUser\";i:57;s:8:\"viewUser\";i:58;s:10:\"createUser\";i:59;s:10:\"updateUser\";i:60;s:10:\"deleteUser\";i:61;s:9:\"viewGroup\";i:62;s:11:\"createGroup\";i:63;s:11:\"updateGroup\";i:64;s:11:\"deleteGroup\";i:65;s:11:\"menuSetting\";i:66;s:11:\"viewSetting\";i:67;s:13:\"updateSetting\";i:68;s:10:\"viewConfig\";i:69;s:12:\"updateConfig\";i:70;s:12:\"viewBankAkun\";i:71;s:14:\"createBankAkun\";i:72;s:14:\"updateBankAkun\";i:73;s:14:\"deleteBankAkun\";i:74;s:10:\"viewBackup\";i:75;s:12:\"createBackup\";i:76;s:12:\"deleteBackup\";i:77;s:11:\"viewLaporan\";i:78;s:11:\"menuLaporan\";i:79;s:19:\"viewLaporanLabaRugi\";i:80;s:13:\"viewStatistik\";i:81;s:13:\"menuStatistik\";i:82;s:11:\"updateShift\";i:83;s:11:\"deleteShift\";}',NULL,'2023-05-06 10:56:57'), 
('3','Kasir','a:29:{i:0;s:13:\"viewDashboard\";i:1;s:13:\"menuDashboard\";i:2;s:13:\"menuTransaksi\";i:3;s:13:\"viewPenjualan\";i:4;s:15:\"createPenjualan\";i:5;s:15:\"updatePenjualan\";i:6;s:11:\"viewPiutang\";i:7;s:13:\"createPiutang\";i:8;s:13:\"updatePiutang\";i:9;s:9:\"viewBiaya\";i:10;s:11:\"createBiaya\";i:11;s:11:\"updateBiaya\";i:12;s:12:\"menuKeuangan\";i:13;s:12:\"viewCashflow\";i:14;s:14:\"createCashflow\";i:15;s:10:\"createBank\";i:16;s:9:\"viewPajak\";i:17;s:11:\"createPajak\";i:18;s:10:\"menuKontak\";i:19;s:10:\"viewKontak\";i:20;s:12:\"createKontak\";i:21;s:12:\"updateKontak\";i:22;s:10:\"viewConfig\";i:23;s:12:\"viewBankAkun\";i:24;s:11:\"viewLaporan\";i:25;s:11:\"menuLaporan\";i:26;s:13:\"viewStatistik\";i:27;s:13:\"menuStatistik\";i:28;s:11:\"updateShift\";}',NULL,'2023-05-06 20:22:32'), 
('4','Sales','a:8:{i:0;s:13:\"viewDashboard\";i:1;s:13:\"menuDashboard\";i:2;s:10:\"menuKontak\";i:3;s:10:\"viewKontak\";i:4;s:12:\"createKontak\";i:5;s:12:\"updateKontak\";i:6;s:12:\"deleteKontak\";i:7;s:11:\"updateShift\";}',NULL,'2023-05-06 20:22:40'), 
('5','Gudang','a:15:{i:0;s:13:\"viewDashboard\";i:1;s:13:\"menuDashboard\";i:2;s:10:\"menuBarang\";i:3;s:10:\"viewBarang\";i:4;s:12:\"createBarang\";i:5;s:12:\"updateBarang\";i:6;s:9:\"viewExcel\";i:7;s:11:\"createExcel\";i:8;s:13:\"viewStokInOut\";i:9;s:15:\"createStokInOut\";i:10;s:15:\"updateStokInOut\";i:11;s:14:\"viewStokOpname\";i:12;s:16:\"createStokOpname\";i:13;s:16:\"updateStokOpname\";i:14;s:11:\"updateShift\";}',NULL,'2023-05-06 20:22:49');
DROP TABLE IF EXISTS `hutang`;
CREATE TABLE `hutang` (
  `id_hutang` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `id_pembelian` int(11) unsigned NOT NULL,
  `tanggal` date DEFAULT NULL,
  `jatuh_tempo` date DEFAULT NULL,
  `jumlah_hutang` int(11) DEFAULT NULL,
  `jumlah_bayar` int(11) DEFAULT NULL,
  `sisa_hutang` int(11) DEFAULT NULL,
  `status_hutang` int(11) NOT NULL DEFAULT 0,
  `id_login` int(11) NOT NULL DEFAULT 0,
  `id_toko` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_hutang`),
  KEY `id_pembelian` (`id_pembelian`),
  KEY `id_login` (`id_login`),
  KEY `id_toko` (`id_toko`),
  CONSTRAINT `hutang_ibfk_1` FOREIGN KEY (`id_pembelian`) REFERENCES `pembelian` (`id_pembelian`),
  CONSTRAINT `hutang_ibfk_2` FOREIGN KEY (`id_login`) REFERENCES `login` (`id_login`),
  CONSTRAINT `hutang_ibfk_3` FOREIGN KEY (`id_toko`) REFERENCES `toko` (`id_toko`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
DROP TABLE IF EXISTS `hutang_bayar`;
CREATE TABLE `hutang_bayar` (
  `id_hutang_bayar` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `id_hutang` int(11) unsigned NOT NULL,
  `nominal` int(11) DEFAULT NULL,
  `id_cashflow` int(11) unsigned NOT NULL DEFAULT 0,
  `id_login` int(11) NOT NULL DEFAULT 0,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_hutang_bayar`),
  KEY `id_hutang` (`id_hutang`),
  CONSTRAINT `hutang_bayar_ibfk_1` FOREIGN KEY (`id_hutang`) REFERENCES `hutang` (`id_hutang`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
DROP TABLE IF EXISTS `kategori`;
CREATE TABLE `kategori` (
  `id_kategori` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `nama_kategori` varchar(255) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_kategori`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
INSERT INTO `kategori` (`id_kategori`,`nama_kategori`,`created_at`,`updated_at`) VALUES ('1','Kopi',NULL,NULL), 
('2','Beras','2022-08-06 15:52:25','2022-08-06 15:52:25'), 
('3','Sembako','2022-08-06 15:54:04','2022-08-06 15:54:04'), 
('4','Rokok','2023-01-01 20:37:40','2023-01-01 20:37:40');
DROP TABLE IF EXISTS `keranjang`;
CREATE TABLE `keranjang` (
  `id_keranjang` varchar(20) NOT NULL DEFAULT '',
  `id_barang` int(11) unsigned NOT NULL DEFAULT 0,
  `id_kontak` int(11) unsigned NOT NULL DEFAULT 0,
  `harga_beli` int(11) NOT NULL DEFAULT 0,
  `harga_jual` int(11) NOT NULL DEFAULT 0,
  `diskon` int(11) NOT NULL DEFAULT 0,
  `diskon_persen` int(11) NOT NULL DEFAULT 0,
  `stok` int(11) DEFAULT NULL,
  `qty` int(11) NOT NULL DEFAULT 0,
  `satuan` varchar(255) DEFAULT NULL,
  `hpp` int(11) NOT NULL DEFAULT 0,
  `jumlah` int(11) NOT NULL DEFAULT 0,
  `ppn` int(11) NOT NULL DEFAULT 0,
  `total_laba` int(11) NOT NULL DEFAULT 0,
  `id_login` int(11) NOT NULL DEFAULT 0,
  `id_toko` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_keranjang`),
  KEY `id_kontak` (`id_kontak`),
  KEY `id_barang` (`id_barang`),
  CONSTRAINT `keranjang_ibfk_2` FOREIGN KEY (`id_kontak`) REFERENCES `kontak` (`id_kontak`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `keranjang_ibfk_3` FOREIGN KEY (`id_barang`) REFERENCES `barang` (`id_barang`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
DROP TABLE IF EXISTS `kontak`;
CREATE TABLE `kontak` (
  `id_kontak` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `tipe` varchar(255) DEFAULT NULL,
  `grup` varchar(255) DEFAULT NULL,
  `nama` varchar(255) NOT NULL,
  `perusahaan` varchar(255) DEFAULT NULL,
  `alamat` text NOT NULL,
  `telepon` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `nikktp` varchar(16) DEFAULT NULL,
  `npwp` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_kontak`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
INSERT INTO `kontak` (`id_kontak`,`tipe`,`grup`,`nama`,`perusahaan`,`alamat`,`telepon`,`email`,`nikktp`,`npwp`,`created_at`,`updated_at`) VALUES ('1','Pelanggan',NULL,'Umum',NULL,'Bogor','628123456789','member@gmail.com','12314121',NULL,NULL,'2022-06-21 12:59:50'), 
('2','Vendor',NULL,'Andri','Iklip Collections','Bandung','628123456789','iklipcollections@gmail.com','123456789',NULL,'2022-05-09 14:17:28','2022-06-14 11:02:54'), 
('3','Pelanggan',NULL,'Customer',NULL,'Bogor','62812345678','customer@gmail.com',NULL,NULL,'2022-06-14 16:30:12','2023-02-26 06:47:20'), 
('4','Pelanggan',NULL,'Putri',NULL,'Jakarta','6282133445566','Putri@gmail.com',NULL,NULL,'2023-03-06 11:40:42','2023-03-06 11:40:42'), 
('5','Pelanggan',NULL,'Rizqi',NULL,'Bogor','62812345678','Rizqi@gmail.com',NULL,NULL,'2023-03-06 13:16:52','2023-05-05 19:25:15');
DROP TABLE IF EXISTS `login`;
CREATE TABLE `login` (
  `id_login` int(11) NOT NULL AUTO_INCREMENT,
  `email` varchar(255) NOT NULL DEFAULT '',
  `nama` varchar(255) DEFAULT NULL,
  `username` varchar(255) NOT NULL,
  `password` varchar(255) NOT NULL DEFAULT '',
  `id_toko` int(11) NOT NULL DEFAULT 0,
  `token` varchar(255) DEFAULT NULL,
  `role` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 0,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_login`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
INSERT INTO `login` (`id_login`,`email`,`nama`,`username`,`password`,`id_toko`,`token`,`role`,`active`,`created_at`,`updated_at`) VALUES ('1','admin@gmail.com','Administrator','admin','$2y$10$INo6IRmOXz4YqFhdxnzRjuqgKGaOuOlhBpxClF5V8xd1KPnmhq.9G','1',NULL,'1','1',NULL,'2022-05-23 08:26:38'), 
('2','kasir@gmail.com','Kasir','kasir','$2y$10$iTLV.WtmYghGjOSnIHJr8eTF0xFzCJTHOemBLK0tCvlpkeBgOWHk2','1',NULL,'2','1','2022-05-11 09:38:59','2022-05-26 18:25:53'), 
('3','manager@gmail.com','Manager','manager','$2y$10$dKFJw/2EF/ki.lT5dBz6auWJnVqtBeYHbWPUpNaXq28mTAzR328Hq','1',NULL,'3','1','2023-02-25 14:31:06','2023-02-25 14:31:06'), 
('4','sales@gmail.com','Sales','sales','$2y$10$4fagP5P0VulbcRe7Tcyq..WEEszuMgkb2MHOzEe4JjPWSGoywjNxC','1',NULL,'4','1','2023-02-25 14:32:03','2023-02-25 14:32:03'), 
('5','gudang@gmail.com','Gudang','gudang','$2y$10$9fZGZFOqt8bAclgOIvCkcuFUAiL.PSzhrIcWT3n7GmhSg9h6B5y22','1',NULL,'5','1','2023-02-25 14:32:32','2023-02-25 14:32:32');
DROP TABLE IF EXISTS `login_group`;
CREATE TABLE `login_group` (
  `id_login_group` int(11) NOT NULL AUTO_INCREMENT,
  `id_login` int(11) NOT NULL,
  `id_group` int(11) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_login_group`),
  KEY `id_group` (`id_group`),
  KEY `id_login` (`id_login`),
  CONSTRAINT `login_group_ibfk_1` FOREIGN KEY (`id_login`) REFERENCES `login` (`id_login`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `login_group_ibfk_2` FOREIGN KEY (`id_group`) REFERENCES `groups` (`id_group`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
INSERT INTO `login_group` (`id_login_group`,`id_login`,`id_group`,`created_at`,`updated_at`) VALUES ('1','1','1',NULL,NULL), 
('2','2','3',NULL,NULL), 
('3','3','2',NULL,'2023-05-05 15:10:06'), 
('4','4','4',NULL,NULL), 
('5','5','5',NULL,'2023-05-06 15:04:22');
DROP TABLE IF EXISTS `login_log`;
CREATE TABLE `login_log` (
  `id_log_login` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(255) NOT NULL DEFAULT '',
  `username` varchar(255) NOT NULL,
  `loggedin_at` datetime DEFAULT NULL,
  `loggedout_at` datetime DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_log_login`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
INSERT INTO `login_log` (`id_log_login`,`email`,`username`,`loggedin_at`,`loggedout_at`,`created_at`,`updated_at`) VALUES ('1','admin@gmail.com','admin','2025-10-05 03:38:12',NULL,'2025-10-05 03:38:12','2025-10-05 03:38:12');
DROP TABLE IF EXISTS `logs`;
CREATE TABLE `logs` (
  `id_log` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `keterangan` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_log`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
INSERT INTO `logs` (`id_log`,`keterangan`,`created_at`) VALUES ('1','Administrator (admin@gmail.com) melakukan Logout at: 2023-11-04 16:47:52','2023-11-04 16:47:52'), 
('2','Administrator (admin@gmail.com) melakukan Login at: 2025-10-05 03:38:12 on device/s: Windows 10/Firefox 140.0','2025-10-05 03:38:12');
DROP TABLE IF EXISTS `media`;
CREATE TABLE `media` (
  `id_media` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `media_path` varchar(255) NOT NULL,
  `id_barang` int(11) unsigned NOT NULL DEFAULT 0,
  `active` int(11) DEFAULT 0,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_media`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
DROP TABLE IF EXISTS `orders`;
CREATE TABLE `orders` (
  `id_order` varchar(20) NOT NULL DEFAULT '',
  `id_barang` int(11) unsigned NOT NULL DEFAULT 0,
  `id_kontak` int(11) unsigned DEFAULT NULL,
  `harga_beli` int(11) NOT NULL DEFAULT 0,
  `harga_jual` int(11) NOT NULL DEFAULT 0,
  `stok` int(11) DEFAULT NULL,
  `qty` int(11) NOT NULL DEFAULT 0,
  `satuan` varchar(255) DEFAULT NULL,
  `jumlah` int(11) NOT NULL DEFAULT 0,
  `id_login` int(11) NOT NULL DEFAULT 0,
  `id_toko` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_order`),
  KEY `id_barang` (`id_barang`),
  CONSTRAINT `orders_ibfk_1` FOREIGN KEY (`id_barang`) REFERENCES `barang` (`id_barang`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
DROP TABLE IF EXISTS `pajak`;
CREATE TABLE `pajak` (
  `id_pajak` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `faktur` varchar(255) DEFAULT NULL,
  `PPN` char(10) DEFAULT '0',
  `jenis` varchar(255) DEFAULT NULL,
  `nominal` int(11) DEFAULT NULL,
  `pembulatan` int(11) NOT NULL DEFAULT 0,
  `keterangan` varchar(255) DEFAULT NULL,
  `id_penjualan` int(11) unsigned DEFAULT NULL,
  `id_toko` int(11) DEFAULT NULL,
  `id_login` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_pajak`),
  KEY `id_penjualan` (`id_penjualan`),
  CONSTRAINT `pajak_ibfk_1` FOREIGN KEY (`id_penjualan`) REFERENCES `penjualan` (`id_penjualan`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
DROP TABLE IF EXISTS `pembelian`;
CREATE TABLE `pembelian` (
  `id_pembelian` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `faktur` varchar(255) DEFAULT NULL,
  `id_kontak` int(11) unsigned DEFAULT NULL,
  `id_login` int(11) NOT NULL DEFAULT 0,
  `id_toko` int(11) DEFAULT NULL,
  `tanggal` date DEFAULT NULL,
  `jatuh_tempo` date DEFAULT NULL,
  `jumlah` int(11) NOT NULL DEFAULT 0,
  `subtotal` int(11) NOT NULL DEFAULT 0,
  `biaya` int(11) NOT NULL DEFAULT 0,
  `total` int(11) NOT NULL DEFAULT 0,
  `status_bayar` int(11) NOT NULL DEFAULT 0,
  `pembayaran` int(11) DEFAULT NULL,
  `catatan` text DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_pembelian`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
DROP TABLE IF EXISTS `pembelian_item`;
CREATE TABLE `pembelian_item` (
  `id_itempembelian` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `id_pembelian` int(11) unsigned DEFAULT NULL,
  `id_barang` int(11) unsigned NOT NULL DEFAULT 0,
  `harga_beli` int(11) DEFAULT NULL,
  `harga_jual` int(11) DEFAULT NULL,
  `qty` int(11) DEFAULT NULL,
  `satuan` varchar(255) DEFAULT NULL,
  `jumlah` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_itempembelian`),
  KEY `id_pembelian` (`id_pembelian`),
  KEY `id_barang` (`id_barang`),
  CONSTRAINT `pembelian_item_ibfk_1` FOREIGN KEY (`id_pembelian`) REFERENCES `pembelian` (`id_pembelian`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `pembelian_item_ibfk_2` FOREIGN KEY (`id_barang`) REFERENCES `barang` (`id_barang`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
DROP TABLE IF EXISTS `penjualan`;
CREATE TABLE `penjualan` (
  `id_penjualan` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `faktur` varchar(255) DEFAULT NULL,
  `id_kontak` int(11) unsigned NOT NULL DEFAULT 0,
  `jumlah` int(11) NOT NULL DEFAULT 0,
  `PPN` char(10) NOT NULL DEFAULT '0',
  `hpp` int(11) NOT NULL DEFAULT 0,
  `subtotal` int(11) NOT NULL DEFAULT 0,
  `diskon` int(11) NOT NULL DEFAULT 0,
  `diskon_persen` int(11) NOT NULL DEFAULT 0,
  `pajak` int(11) NOT NULL DEFAULT 0,
  `pembulatan` int(11) NOT NULL DEFAULT 0,
  `total` int(11) NOT NULL DEFAULT 0,
  `bayar` int(11) NOT NULL DEFAULT 0,
  `kembali` int(11) NOT NULL DEFAULT 0,
  `total_laba` int(11) NOT NULL DEFAULT 0,
  `periode` varchar(255) DEFAULT NULL,
  `id_login` int(11) NOT NULL DEFAULT 0,
  `id_toko` int(11) DEFAULT NULL,
  `metode_bayar` varchar(255) DEFAULT NULL,
  `catatan` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_penjualan`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
DROP TABLE IF EXISTS `penjualan_item`;
CREATE TABLE `penjualan_item` (
  `id_itempenjualan` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `id_barang` int(11) unsigned NOT NULL DEFAULT 0,
  `id_penjualan` int(11) unsigned DEFAULT NULL,
  `harga_beli` int(11) DEFAULT NULL,
  `harga_jual` int(11) DEFAULT NULL,
  `diskon` int(11) NOT NULL DEFAULT 0,
  `diskon_persen` int(11) NOT NULL DEFAULT 0,
  `stok` int(11) DEFAULT NULL,
  `qty` int(11) DEFAULT NULL,
  `satuan` varchar(255) DEFAULT NULL,
  `hpp` int(11) NOT NULL DEFAULT 0,
  `jumlah` int(11) DEFAULT NULL,
  `ppn` int(11) NOT NULL DEFAULT 0,
  `total_laba` int(11) NOT NULL DEFAULT 0,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_itempenjualan`),
  KEY `id_barang` (`id_barang`),
  KEY `id_penjualan` (`id_penjualan`),
  CONSTRAINT `penjualan_item_ibfk_1` FOREIGN KEY (`id_penjualan`) REFERENCES `penjualan` (`id_penjualan`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `penjualan_item_ibfk_2` FOREIGN KEY (`id_barang`) REFERENCES `barang` (`id_barang`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
DROP TABLE IF EXISTS `piutang`;
CREATE TABLE `piutang` (
  `id_piutang` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `id_penjualan` int(11) unsigned NOT NULL,
  `tanggal` date DEFAULT NULL,
  `jatuh_tempo` date DEFAULT NULL,
  `jumlah_piutang` int(11) DEFAULT NULL,
  `jumlah_bayar` int(11) DEFAULT NULL,
  `sisa_piutang` int(11) DEFAULT NULL,
  `status_piutang` int(11) NOT NULL DEFAULT 0,
  `keterangan` varchar(255) DEFAULT NULL,
  `id_login` int(11) NOT NULL DEFAULT 0,
  `id_toko` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_piutang`),
  KEY `id_penjualan` (`id_penjualan`),
  KEY `id_login` (`id_login`),
  KEY `id_toko` (`id_toko`),
  CONSTRAINT `piutang_ibfk_1` FOREIGN KEY (`id_penjualan`) REFERENCES `penjualan` (`id_penjualan`),
  CONSTRAINT `piutang_ibfk_2` FOREIGN KEY (`id_login`) REFERENCES `login` (`id_login`),
  CONSTRAINT `piutang_ibfk_3` FOREIGN KEY (`id_toko`) REFERENCES `toko` (`id_toko`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
DROP TABLE IF EXISTS `piutang_bayar`;
CREATE TABLE `piutang_bayar` (
  `id_piutang_bayar` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `id_piutang` int(11) unsigned NOT NULL DEFAULT 0,
  `nominal` int(11) DEFAULT NULL,
  `id_cashflow` int(11) unsigned NOT NULL DEFAULT 0,
  `id_login` int(11) NOT NULL DEFAULT 0,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_piutang_bayar`),
  KEY `id_piutang` (`id_piutang`),
  CONSTRAINT `piutang_bayar_ibfk_1` FOREIGN KEY (`id_piutang`) REFERENCES `piutang` (`id_piutang`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
DROP TABLE IF EXISTS `satuan`;
CREATE TABLE `satuan` (
  `id_satuan` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `nama_satuan` varchar(255) NOT NULL DEFAULT '',
  `nilai_satuan` int(11) NOT NULL DEFAULT 0,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_satuan`),
  KEY `nama_satuan` (`nama_satuan`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
INSERT INTO `satuan` (`id_satuan`,`nama_satuan`,`nilai_satuan`,`created_at`,`updated_at`) VALUES ('1','pcs','1',NULL,NULL), 
('2','buah','1',NULL,NULL), 
('3','butir','1',NULL,NULL), 
('4','bungkus','1','2023-01-01 20:38:07','2023-01-01 20:38:07'), 
('5','gram','100',NULL,NULL), 
('6','kg','1',NULL,NULL), 
('7','roll','1',NULL,NULL), 
('8','lembar','1',NULL,NULL);
DROP TABLE IF EXISTS `settings`;
CREATE TABLE `settings` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `group_setting` varchar(100) NOT NULL,
  `variable_setting` varchar(255) NOT NULL,
  `value_setting` text NOT NULL,
  `deskripsi_setting` varchar(255) NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
INSERT INTO `settings` (`id`,`group_setting`,`variable_setting`,`value_setting`,`deskripsi_setting`,`updated_at`) VALUES ('1','general','app_name','coPOS Toko/Warung','App Name','2022-05-09 06:16:12'), 
('2','general','app_version','1','App Version','2022-05-26 18:22:10'), 
('3','general','app_release','2023-01-04 08:24:55','App Release','2023-01-04 08:24:55'), 
('4','general','app_developer','Cepat Online','App Developer','2022-05-11 17:05:03'), 
('5','image','img_favicon','assets/images/favicon.png','Favicon','2022-11-12 13:14:59'), 
('6','image','img_logo','assets/images/logo.png','Logo','2022-11-13 09:47:27'), 
('7','image','img_logo_resize','assets/images/res_logo.png','Logo Resized','2022-11-13 09:47:28'), 
('8','image','img_background','assets/images/background.jpg','Background','2022-03-10 13:17:10'), 
('9','app','snackbars_position','bottom','Posisi Snackbars Notification','2022-12-28 07:22:22'), 
('10','app','limit_loginlog','2000','Limit Login Log (default 2000)','2023-01-04 08:24:55'), 
('11','app','enable_frontend','true','Tampilkan Home atau Halaman Login','2023-02-24 18:22:33'), 
('12','app','cashierpay_position','left','Posisi Tombol Pay Kasir','2023-02-26 13:18:48'), 
('13','app','navbar_color','indigo','Navbar Color','2023-08-06 16:36:30'), 
('14','app','sidebar_color','indigo','Sidebar Color','2023-08-06 16:36:36');
DROP TABLE IF EXISTS `shift`;
CREATE TABLE `shift` (
  `id_shift` int(11) NOT NULL AUTO_INCREMENT,
  `nama_shift` varchar(255) DEFAULT NULL,
  `jam_mulai` time DEFAULT NULL,
  `jam_selesai` time DEFAULT NULL,
  `id_toko` int(11) NOT NULL DEFAULT 0,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_shift`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;
INSERT INTO `shift` (`id_shift`,`nama_shift`,`jam_mulai`,`jam_selesai`,`id_toko`,`created_at`,`updated_at`) VALUES ('1','Shift 1','07:00:00','15:00:00','1',NULL,'2023-04-30 12:03:29'), 
('2','Shift 2','15:00:00','21:00:00','1',NULL,'2023-04-30 12:03:46'), 
('3','Shift 3','00:00:00','00:00:00','1',NULL,NULL), 
('4',NULL,NULL,NULL,'1',NULL,NULL), 
('5',NULL,NULL,NULL,'1',NULL,NULL);
DROP TABLE IF EXISTS `shift_openclose`;
CREATE TABLE `shift_openclose` (
  `id_shift_openclose` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `id_shift` int(11) NOT NULL,
  `type` char(20) DEFAULT NULL,
  `tanggal` date DEFAULT NULL,
  `waktu` time DEFAULT NULL,
  `id_login` int(11) NOT NULL DEFAULT 0,
  `supervisor` int(11) NOT NULL DEFAULT 0,
  `jumlah_uang_kertas` int(11) DEFAULT NULL,
  `jumlah_uang_koin` int(11) DEFAULT NULL,
  `id_toko` int(11) NOT NULL DEFAULT 0,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_shift_openclose`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `shift_openclose_detail`;
CREATE TABLE `shift_openclose_detail` (
  `id_shift_openclose_detail` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `id_shift_openclose` int(11) unsigned NOT NULL,
  `kertas100` int(11) NOT NULL DEFAULT 0,
  `kertas50` int(11) NOT NULL DEFAULT 0,
  `kertas20` int(11) NOT NULL DEFAULT 0,
  `kertas10` int(11) NOT NULL DEFAULT 0,
  `kertas5` int(11) NOT NULL DEFAULT 0,
  `kertas2` int(11) NOT NULL DEFAULT 0,
  `kertas1` int(11) NOT NULL DEFAULT 0,
  `koin1000` int(11) NOT NULL DEFAULT 0,
  `koin500` int(11) NOT NULL DEFAULT 0,
  `koin200` int(11) NOT NULL DEFAULT 0,
  `koin100` int(11) NOT NULL DEFAULT 0,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_shift_openclose_detail`),
  KEY `id_shift_openclose` (`id_shift_openclose`),
  CONSTRAINT `shift_openclose_detail_ibfk_1` FOREIGN KEY (`id_shift_openclose`) REFERENCES `shift_openclose` (`id_shift_openclose`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `stok`;
CREATE TABLE `stok` (
  `id_stok` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `id_barang` int(11) unsigned NOT NULL DEFAULT 0,
  `jenis` varchar(255) DEFAULT NULL,
  `jumlah` varchar(255) DEFAULT NULL,
  `nilai` varchar(255) DEFAULT NULL,
  `keterangan` varchar(255) DEFAULT NULL,
  `id_toko` int(11) DEFAULT NULL,
  `id_login` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_stok`),
  KEY `id_barang` (`id_barang`),
  CONSTRAINT `stok_ibfk_1` FOREIGN KEY (`id_barang`) REFERENCES `barang` (`id_barang`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `stok_opname`;
CREATE TABLE `stok_opname` (
  `id_stok_opname` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `id_barang` int(11) unsigned NOT NULL DEFAULT 0,
  `stok` int(11) DEFAULT NULL,
  `stok_nyata` int(11) DEFAULT NULL,
  `selisih` varchar(255) DEFAULT NULL,
  `nilai` varchar(255) DEFAULT NULL,
  `keterangan` varchar(255) DEFAULT NULL,
  `id_toko` int(11) DEFAULT NULL,
  `id_login` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_stok_opname`),
  KEY `id_barang` (`id_barang`),
  CONSTRAINT `stok_opname_ibfk_1` FOREIGN KEY (`id_barang`) REFERENCES `barang` (`id_barang`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `toko`;
CREATE TABLE `toko` (
  `id_toko` int(11) NOT NULL AUTO_INCREMENT,
  `nama_toko` varchar(255) NOT NULL,
  `alamat_toko` text NOT NULL,
  `telp` varchar(255) NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `nama_pemilik` varchar(255) NOT NULL,
  `NIB` char(15) DEFAULT NULL,
  `PPN` char(10) DEFAULT '0',
  `include_ppn` int(11) NOT NULL DEFAULT 0,
  `kode_barang` varchar(255) DEFAULT NULL,
  `kode_jual` varchar(255) DEFAULT NULL,
  `kode_jual_tahun` int(11) DEFAULT 0,
  `kode_beli` varchar(255) DEFAULT NULL,
  `kode_kas` varchar(255) DEFAULT NULL,
  `kode_bank` varchar(255) DEFAULT NULL,
  `kode_pajak` varchar(255) DEFAULT NULL,
  `kode_biaya` varchar(255) DEFAULT NULL,
  `paper_size` char(10) DEFAULT '0',
  `footer_nota` varchar(255) DEFAULT NULL,
  `printer_usb` int(11) DEFAULT 0,
  `printer_bluetooth` int(11) DEFAULT 0,
  `scan_keranjang` int(11) DEFAULT 0,
  `id_bank_akun` int(11) NOT NULL DEFAULT 0,
  `jatuhtempo_hari_tanggal` int(11) NOT NULL DEFAULT 0,
  `jatuhtempo_keterangan` int(11) NOT NULL DEFAULT 0,
  `jatuhtempo_hari` int(11) NOT NULL DEFAULT 0,
  `jatuhtempo_tanggal` int(11) NOT NULL DEFAULT 0,
  `pembulatan` int(11) NOT NULL DEFAULT 0,
  `pembulatan_keatas` int(11) NOT NULL DEFAULT 0,
  `pembulatan_max` int(11) NOT NULL DEFAULT 0,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_toko`),
  KEY `id_bank_akun` (`id_bank_akun`),
  CONSTRAINT `toko_ibfk_1` FOREIGN KEY (`id_bank_akun`) REFERENCES `bank_akun` (`id_bank_akun`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
INSERT INTO `toko` (`id_toko`,`nama_toko`,`alamat_toko`,`telp`,`email`,`nama_pemilik`,`NIB`,`PPN`,`include_ppn`,`kode_barang`,`kode_jual`,`kode_jual_tahun`,`kode_beli`,`kode_kas`,`kode_bank`,`kode_pajak`,`kode_biaya`,`paper_size`,`footer_nota`,`printer_usb`,`printer_bluetooth`,`scan_keranjang`,`id_bank_akun`,`jatuhtempo_hari_tanggal`,`jatuhtempo_keterangan`,`jatuhtempo_hari`,`jatuhtempo_tanggal`,`pembulatan`,`pembulatan_keatas`,`pembulatan_max`,`updated_at`) VALUES ('1','Warung Nita (RN)','Dukuhwaluh Gg. Manggis RT 1 RW 7','08123456789','warungnita@gmail.com','Hari Wicaksono','012345678','0','0','BRG-','PJ/','1','PI/','KAS/','BANK/','PPN/','BYA/','58','Terima kasih sudah berbelanja, Barang yang sudah dibeli tidak dapat dikembalikan','1','1','1','2','0','1','3','20','1','1','100','2023-10-14 06:51:44');
SET FOREIGN_KEY_CHECKS=1;
