<?php

namespace App\Modules\Backup\Controllers;

/*
 * AKHINA MUAZI
 */

use App\Controllers\BaseController;
use App\Libraries\Settings;
use CodeIgniter\Files\File;
use Config\Database;

class Backup extends BaseController
{
    protected $setting;

    public function __construct()
    {
        $this->setting = new Settings();
    }

    public function index()
    {
        return view('App\Modules\Backup\Views/backup', [
            'title' => 'Backup DB & Restore'
        ]);
    }

    /**
     * Restore database dari file .sql
     */
    public function restore()
    {
        helper(['filesystem']);

        $file = $this->request->getFile('file');

        if (!$file || !$file->isValid()) {
            return $this->response->setJSON([
                'status' => false,
                'message' => 'Upload file gagal atau tidak valid.'
            ]);
        }

        // Cek ekstensi file
        $ext = strtolower($file->getExtension());
        if ($ext !== 'sql') {
            return $this->response->setJSON([
                'status' => false,
                'message' => 'Hanya file .sql yang diperbolehkan untuk restore.'
            ]);
        }

        // Simpan file sementara
        $newName = $file->getRandomName();
        $uploadPath = WRITEPATH . 'uploads/';
        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }

        $file->move($uploadPath, $newName);
        $filePath = $uploadPath . $newName;

        // Jalankan isi SQL ke database
        $db = Database::connect();
        $sqlContent = file_get_contents($filePath);

        try {
            // Pecah berdasarkan tanda ';' agar tidak error di banyak query
            $queries = explode(";\n", $sqlContent);
            foreach ($queries as $query) {
                $trimmed = trim($query);
                if (!empty($trimmed)) {
                    $db->query($trimmed);
                }
            }

            // Hapus file setelah restore selesai
            unlink($filePath);

            return $this->response->setJSON([
                'status' => true,
                'message' => 'Restore database berhasil dilakukan.'
            ]);
        } catch (\Throwable $e) {
            return $this->response->setJSON([
                'status' => false,
                'message' => 'Restore gagal: ' . $e->getMessage()
            ]);
        }
    }
}
