<?php

namespace Config;

use CodeIgniter\Config\BaseConfig;
use CodeIgniter\Validation\StrictRules\CreditCardRules;
use CodeIgniter\Validation\StrictRules\FileRules;
use CodeIgniter\Validation\StrictRules\FormatRules;
use CodeIgniter\Validation\StrictRules\Rules;
use App\Validation\UserRules;

class Validation extends BaseConfig
{
	//--------------------------------------------------------------------
	// Setup
	//--------------------------------------------------------------------

	/**
     * Stores the classes that contain the
     * rules that are available.
     *
     * @var string[]
     */
	public array $ruleSets = [
		Rules::class,
		FormatRules::class,
		FileRules::class,
		CreditCardRules::class,
		UserRules::class,
	];

	/**
     * Specifies the views that are used to display the
     * errors.
     *
     * @var array<string, string>
     */
	public array $templates = [
		'list'   => 'CodeIgniter\Validation\Views\list',
		'single' => 'CodeIgniter\Validation\Views\single',
		'text'   => 'App\Validation\Views\text',
	];

	//--------------------------------------------------------------------
	// Rules
	//--------------------------------------------------------------------
}
